/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.disk_usage;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.ItemGroup;
import hudson.model.ProminentProjectAction;
import hudson.plugins.disk_usage.BuildDiskUsageAction;
import hudson.plugins.disk_usage.DiskUsageBuildInformation;
import hudson.plugins.disk_usage.DiskUsageGraph;
import hudson.plugins.disk_usage.DiskUsagePlugin;
import hudson.plugins.disk_usage.DiskUsageProperty;
import hudson.plugins.disk_usage.DiskUsageUtil;
import hudson.plugins.disk_usage.Messages;
import hudson.util.Graph;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=1)
public class ProjectDiskUsageAction
implements ProminentProjectAction {
    AbstractProject<? extends AbstractProject<?, ?>, ? extends AbstractBuild<?, ?>> project;

    public ProjectDiskUsageAction(AbstractProject<? extends AbstractProject<?, ?>, ? extends AbstractBuild<?, ?>> project) {
        this.project = project;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return Messages.displayName();
    }

    public String getUrlName() {
        return Messages.urlName();
    }

    public Long getDiskUsageWorkspace() {
        DiskUsageProperty property = (DiskUsageProperty)this.project.getProperty(DiskUsageProperty.class);
        if (property == null) {
            DiskUsageUtil.addProperty(this.project);
            property = (DiskUsageProperty)this.project.getProperty(DiskUsageProperty.class);
        }
        return property.getAllWorkspaceSize();
    }

    @Deprecated(forRemoval=true)
    public Long getAllSlaveWorkspaces() {
        return this.getAllAgentWorkspaces();
    }

    public Long getAllAgentWorkspaces() {
        return this.getAllDiskUsageWorkspace() - this.getAllCustomOrNonAgentWorkspaces();
    }

    @Deprecated(forRemoval=true)
    public Long getAllCustomOrNonSlaveWorkspaces() {
        return this.getAllCustomOrNonAgentWorkspaces();
    }

    public Long getAllCustomOrNonAgentWorkspaces() {
        Long diskUsage = 0L;
        DiskUsageProperty property = (DiskUsageProperty)this.project.getProperty(DiskUsageProperty.class);
        if (property != null) {
            diskUsage = diskUsage + property.getAllNonAgentOrCustomWorkspaceSize();
        }
        if (this.project instanceof ItemGroup) {
            ItemGroup group = (ItemGroup)this.project;
            for (Object i : group.getItems()) {
                AbstractProject p;
                DiskUsageProperty prop;
                if (!(i instanceof AbstractProject) || (prop = (DiskUsageProperty)(p = (AbstractProject)i).getProperty(DiskUsageProperty.class)) == null) continue;
                diskUsage = diskUsage + prop.getAllNonAgentOrCustomWorkspaceSize();
            }
        }
        return diskUsage;
    }

    public Long getAllDiskUsageWorkspace() {
        Long diskUsage = 0L;
        DiskUsageProperty property = (DiskUsageProperty)this.project.getProperty(DiskUsageProperty.class);
        if (property != null) {
            diskUsage = diskUsage + property.getAllWorkspaceSize();
        }
        if (this.project instanceof ItemGroup) {
            ItemGroup group = (ItemGroup)this.project;
            for (Object i : group.getItems()) {
                AbstractProject p;
                DiskUsageProperty prop;
                if (!(i instanceof AbstractProject) || (prop = (DiskUsageProperty)(p = (AbstractProject)i).getProperty(DiskUsageProperty.class)) == null) continue;
                diskUsage = diskUsage + prop.getAllWorkspaceSize();
            }
        }
        return diskUsage;
    }

    public String getSizeInString(Long size) {
        return DiskUsageUtil.getSizeString(size);
    }

    public Long getDiskUsageWithoutBuilds() {
        DiskUsageProperty property = (DiskUsageProperty)this.project.getProperty(DiskUsageProperty.class);
        if (property == null) {
            DiskUsageUtil.addProperty(this.project);
            property = (DiskUsageProperty)this.project.getProperty(DiskUsageProperty.class);
        }
        return property.getDiskUsageWithoutBuilds();
    }

    public Long getAllDiskUsageWithoutBuilds() {
        DiskUsageProperty property = (DiskUsageProperty)this.project.getProperty(DiskUsageProperty.class);
        if (property == null) {
            DiskUsageUtil.addProperty(this.project);
            property = (DiskUsageProperty)this.project.getProperty(DiskUsageProperty.class);
        }
        return property.getAllDiskUsageWithoutBuilds();
    }

    public Long getJobRootDirDiskUsage() {
        try {
            return this.getBuildsDiskUsage().get("all") + this.getDiskUsageWithoutBuilds();
        }
        catch (IOException ex) {
            Logger.getLogger(ProjectDiskUsageAction.class.getName()).log(Level.SEVERE, null, ex);
            return 0L;
        }
    }

    private Map<String, Long> getBuildsDiskUsageAllSubItems(ItemGroup<?> group, Date older, Date yonger) throws IOException {
        TreeMap<String, Long> diskUsage = new TreeMap<String, Long>();
        Long buildsDiskUsage = 0L;
        Long locked = 0L;
        Long notLoaded = 0L;
        for (Object item : group.getItems()) {
            if (item instanceof ItemGroup) {
                ItemGroup subGroup = (ItemGroup)item;
                buildsDiskUsage = buildsDiskUsage + this.getBuildsDiskUsageAllSubItems(subGroup, older, yonger).get("all");
                locked = locked + this.getBuildsDiskUsageAllSubItems(subGroup, older, yonger).get("locked");
                notLoaded = notLoaded + this.getBuildsDiskUsageAllSubItems(subGroup, older, yonger).get("notLoaded");
                continue;
            }
            if (!(group instanceof AbstractProject)) continue;
            AbstractProject p = (AbstractProject)item;
            DiskUsageProperty property = (DiskUsageProperty)p.getProperty(DiskUsageProperty.class);
            if (property == null) {
                DiskUsageUtil.addProperty(this.project);
                property = (DiskUsageProperty)this.project.getProperty(DiskUsageProperty.class);
            }
            Set<DiskUsageBuildInformation> informations = property.getDiskUsageOfBuilds();
            for (DiskUsageBuildInformation information : informations) {
                Date date = new Date(information.getTimestamp());
                if (older != null && !date.before(older) || yonger != null && !date.after(yonger)) continue;
                Long size = information.getSize();
                buildsDiskUsage = buildsDiskUsage + size;
                Collection loadedBuilds = p._getRuns().getLoadedBuilds().values();
                AbstractBuild build = null;
                for (AbstractBuild b : loadedBuilds) {
                    if (!b.getId().equals(information.getId())) continue;
                    build = b;
                }
                if (build != null) {
                    if (!build.isKeepLog()) continue;
                    locked = locked + size;
                    continue;
                }
                notLoaded = notLoaded + size;
            }
        }
        diskUsage.put("all", buildsDiskUsage);
        diskUsage.put("locked", locked);
        diskUsage.put("notLoaded", notLoaded);
        return diskUsage;
    }

    public Map<String, Long> getBuildsDiskUsage() throws IOException {
        return this.getBuildsDiskUsage(null, null);
    }

    public Long getAllBuildsDiskUsage() throws IOException {
        return this.getBuildsDiskUsage(null, null).get("all");
    }

    public Map<String, Long> getBuildsDiskUsage(Date older, Date yonger) throws IOException {
        DiskUsageProperty property = (DiskUsageProperty)this.project.getProperty(DiskUsageProperty.class);
        if (property == null) {
            DiskUsageUtil.addProperty(this.project);
            property = (DiskUsageProperty)this.project.getProperty(DiskUsageProperty.class);
        }
        TreeMap<String, Long> diskUsage = new TreeMap<String, Long>();
        Long buildsDiskUsage = 0L;
        Long locked = 0L;
        Long notLoaded = 0L;
        if (this.project instanceof ItemGroup) {
            ItemGroup group = (ItemGroup)this.project;
            Map<String, Long> sizes = this.getBuildsDiskUsageAllSubItems(group, older, yonger);
            buildsDiskUsage = buildsDiskUsage + sizes.get("all");
            locked = locked + sizes.get("locked");
            notLoaded = notLoaded + sizes.get("notLoaded");
        }
        Set<DiskUsageBuildInformation> informations = property.getDiskUsageOfBuilds();
        for (DiskUsageBuildInformation information : informations) {
            Date date = new Date(information.getTimestamp());
            if (older != null && !date.before(older) || yonger != null && !date.after(yonger)) continue;
            Long size = information.getSize();
            buildsDiskUsage = buildsDiskUsage + size;
            Collection loadedBuilds = this.project._getRuns().getLoadedBuilds().values();
            AbstractBuild build = null;
            for (AbstractBuild b : loadedBuilds) {
                if (!b.getId().equals(information.getId())) continue;
                build = b;
            }
            if (build != null) {
                if (!build.isKeepLog()) continue;
                locked = locked + size;
                continue;
            }
            notLoaded = notLoaded + size;
        }
        diskUsage.put("all", buildsDiskUsage);
        diskUsage.put("locked", locked);
        diskUsage.put("notLoaded", notLoaded);
        return diskUsage;
    }

    public BuildDiskUsageAction getLastBuildAction() {
        AbstractBuild run = this.project.getLastBuild();
        if (run != null) {
            return (BuildDiskUsageAction)run.getAction(BuildDiskUsageAction.class);
        }
        return null;
    }

    public Set<DiskUsageBuildInformation> getBuildsInformation() throws IOException {
        DiskUsageProperty property = (DiskUsageProperty)this.project.getProperty(DiskUsageProperty.class);
        if (property == null) {
            DiskUsageUtil.addProperty(this.project);
            property = (DiskUsageProperty)this.project.getProperty(DiskUsageProperty.class);
        }
        return property.getDiskUsageOfBuilds();
    }

    public Graph getGraph() throws IOException {
        ArrayList<Object[]> usages = new ArrayList<Object[]>();
        long maxValue = 0L;
        long maxValueWorkspace = 0L;
        DiskUsageProperty property = (DiskUsageProperty)this.project.getProperty(DiskUsageProperty.class);
        maxValueWorkspace = Math.max(this.getAllCustomOrNonAgentWorkspaces(), this.getAllAgentWorkspaces());
        maxValue = this.getJobRootDirDiskUsage();
        List builds = property.getDiskUsageOfBuilds().stream().sorted((a, b) -> b.getNumber() - a.getNumber()).collect(Collectors.toList());
        for (int i = builds.size() - 1; i >= 0; --i) {
            DiskUsageBuildInformation build = (DiskUsageBuildInformation)builds.get(i);
            Long diskUsage = property.getDiskUsageOfBuild(build.getId());
            usages.add(new Object[]{build.getNumber(), this.getJobRootDirDiskUsage(), diskUsage, this.getAllAgentWorkspaces(), this.getAllCustomOrNonAgentWorkspaces()});
            maxValue = Math.max(maxValue, diskUsage);
        }
        int floor = (int)DiskUsageUtil.getScale(maxValue);
        String unit = DiskUsageUtil.getUnitString(floor);
        int workspaceFloor = (int)DiskUsageUtil.getScale(maxValueWorkspace);
        String workspaceUnit = DiskUsageUtil.getUnitString(workspaceFloor);
        double base = Math.pow(1024.0, floor);
        double workspaceBase = Math.pow(1024.0, workspaceFloor);
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        DefaultCategoryDataset dataset2 = new DefaultCategoryDataset();
        for (Object[] usage : usages) {
            String label = "#" + String.valueOf(usage[0]);
            dataset.addValue((double)((Long)usage[1]).longValue() / base, (Comparable)((Object)Messages.DiskUsage_Graph_JobDirectory()), (Comparable)((Object)label));
            dataset.addValue((double)((Long)usage[2]).longValue() / base, (Comparable)((Object)Messages.DiskUsage_Graph_BuildDirectory()), (Comparable)((Object)label));
            dataset2.addValue((double)((Long)usage[3]).longValue() / workspaceBase, (Comparable)((Object)Messages.DiskUsage_Graph_AgentWorkspaces()), (Comparable)((Object)label));
            dataset2.addValue((double)((Long)usage[4]).longValue() / workspaceBase, (Comparable)((Object)Messages.DiskUsage_Graph_NonAgentWorkspaces()), (Comparable)((Object)label));
        }
        return new DiskUsageGraph((CategoryDataset)dataset, unit, (CategoryDataset)dataset2, workspaceUnit);
    }

    public boolean showGraph() {
        DiskUsagePlugin plugin = (DiskUsagePlugin)Jenkins.get().getPlugin(DiskUsagePlugin.class);
        if (plugin == null) {
            return false;
        }
        return plugin.getConfiguration().isShowGraph();
    }
}

