/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.disk_usage;

import hudson.plugins.disk_usage.Messages;
import hudson.util.Graph;
import hudson.util.ShiftedCategoryAxis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;

public class DiskUsageGraph
extends Graph {
    CategoryDataset dataset;
    CategoryDataset workspaceDataset;
    String unit;
    String workspaceUnit;

    public DiskUsageGraph(CategoryDataset dataset, String unit, CategoryDataset workspaceDataset, String workspaceUnit) {
        super(-1L, 350, 150);
        this.workspaceDataset = workspaceDataset;
        this.dataset = dataset;
        this.unit = unit;
        this.workspaceUnit = workspaceUnit;
    }

    protected JFreeChart createGraph() {
        JFreeChart chart = ChartFactory.createAreaChart(null, null, (String)(Messages.DiskUsage_Graph_JobDiskUsageAxis() + " [" + this.unit + "]"), (CategoryDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.BOTTOM);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(-((double)this.dataset.getColumnCount() / 10.0));
        plot.setDataset(1, this.workspaceDataset);
        LineAndShapeRenderer renderer = new LineAndShapeRenderer();
        renderer.setBaseShapesVisible(false);
        renderer.setSeriesStroke(0, (Stroke)new BasicStroke(4.0f, 1, 2));
        renderer.setSeriesStroke(1, (Stroke)new BasicStroke(4.0f, 1, 2));
        plot.setRenderer(1, (CategoryItemRenderer)renderer);
        NumberAxis rangeAxis = new NumberAxis(Messages.DiskUsage_Graph_WorkspaceDiskUsageAxis() + " [" + this.workspaceUnit + "]");
        plot.setRangeAxis(1, (ValueAxis)rangeAxis);
        plot.mapDatasetToRangeAxis(1, 1);
        this.setColorForArea(plot.getRenderer(), this.dataset.getRowCount() > 2);
        plot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        renderer.setSeriesPaint(1, (Paint)new Color(255, 204, 0));
        return chart;
    }

    public void setColorForArea(CategoryItemRenderer renderer, boolean global) {
        if (global) {
            renderer.setSeriesPaint(0, (Paint)Color.LIGHT_GRAY);
            renderer.setSeriesPaint(1, (Paint)new Color(60, 179, 113));
            renderer.setSeriesPaint(2, (Paint)new Color(106, 90, 205));
        } else {
            renderer.setSeriesPaint(0, (Paint)new Color(60, 179, 113));
            renderer.setSeriesPaint(1, (Paint)new Color(106, 90, 205));
        }
    }
}

