/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.disk_usage;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Objects;

public class DiskUsageBuildInformation
implements Serializable,
Comparable<DiskUsageBuildInformation> {
    private static final long serialVersionUID = 8936406908101796594L;
    private static final String PATTERN = "yyyy-MM-dd_HH-mm-ss";
    private String id;
    private long timestamp;
    private int number;
    private Long size;

    public DiskUsageBuildInformation(String id, long timestamp, int number, Long size) {
        this.id = id;
        this.timestamp = timestamp;
        this.number = number;
        this.size = size;
    }

    private Object readResolve() {
        if (this.timestamp == 0L) {
            try {
                this.timestamp = new SimpleDateFormat(PATTERN).parse(this.id).getTime();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return this;
    }

    public String getId() {
        return this.id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getNumber() {
        return this.number;
    }

    public Long getSize() {
        if (this.size == null) {
            return 0L;
        }
        return this.size;
    }

    public boolean equals(Object o) {
        if (o instanceof DiskUsageBuildInformation) {
            DiskUsageBuildInformation information = (DiskUsageBuildInformation)o;
            return information.getId().equals(this.id);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    @Override
    public int compareTo(DiskUsageBuildInformation o) {
        if (o != null) {
            return this.id.compareTo(o.getId());
        }
        throw new IllegalArgumentException("Can not compare with different type");
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public String toString() {
        return "Id " + this.id + " number " + this.number + " size " + this.size;
    }
}

