/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.disk_usage;

import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.BulkChange;
import hudson.FilePath;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.listeners.SaveableListener;
import hudson.plugins.disk_usage.DiskUsageBuildInformation;
import hudson.plugins.disk_usage.DiskUsageProperty;
import hudson.util.RunList;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.FileUtils;

public class ProjectDiskUsage
implements Saveable {
    protected transient Job job;
    protected Long diskUsageWithoutBuilds = 0L;
    protected Map<String, Map<String, Long>> slaveWorkspacesUsage = new ConcurrentHashMap<String, Map<String, Long>>();
    private Set<DiskUsageBuildInformation> buildDiskUsage = new CopyOnWriteArraySet<DiskUsageBuildInformation>();
    private boolean allBuildsLoaded;

    @Deprecated(forRemoval=true)
    public Map<String, Map<String, Long>> getSlaveWorkspacesUsage() {
        return this.getAgentWorkspacesUsage();
    }

    public Map<String, Map<String, Long>> getAgentWorkspacesUsage() {
        return Maps.newHashMap(this.slaveWorkspacesUsage);
    }

    public XmlFile getConfigFile() {
        return new XmlFile(new File(this.job.getRootDir(), "disk-usage.xml"));
    }

    public void setProject(Job job) {
        this.job = job;
    }

    public boolean isBuildsLoaded() {
        return this.buildDiskUsage != null;
    }

    public Set<DiskUsageBuildInformation> getBuildDiskUsage(boolean needAll) {
        HashSet<DiskUsageBuildInformation> information = new HashSet<DiskUsageBuildInformation>();
        if (needAll && !this.allBuildsLoaded) {
            try {
                this.loadAllBuilds();
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Failed to load builds " + String.valueOf(this.getConfigFile()), e);
            }
        }
        information.addAll(this.buildDiskUsage);
        return information;
    }

    public synchronized void save() {
        if (BulkChange.contains((Saveable)this)) {
            return;
        }
        try {
            this.getConfigFile().write((Object)this);
            SaveableListener.fireOnChange((Saveable)this, (XmlFile)this.getConfigFile());
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Failed to save " + String.valueOf(this.getConfigFile()), e);
        }
    }

    public void removeBuild(DiskUsageBuildInformation information) {
        this.buildDiskUsage.remove(information);
    }

    private int numberOfBuildFolders() throws IOException {
        File file = this.job.getBuildDir();
        int count = 0;
        if (file != null && file.exists() && file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) {
                return count;
            }
            for (File f : files) {
                if (FileUtils.isSymlink((File)f) || f.isDirectory()) continue;
                ++count;
            }
        }
        return count;
    }

    @Deprecated(forRemoval=true)
    public void putSlaveWorkspaceSize(Node node, String path, Long size) {
        this.putAgentWorkspaceSize(node, path, size);
    }

    public void putAgentWorkspaceSize(@NonNull Node node, String path, Long size) {
        Map<String, Long> workspacesInfo = this.slaveWorkspacesUsage.get(node.getNodeName());
        if (workspacesInfo == null) {
            workspacesInfo = new ConcurrentHashMap<String, Long>();
        }
        if (workspacesInfo.get(path) == null || size > 0L) {
            workspacesInfo.put(path, size);
        }
        this.slaveWorkspacesUsage.put(node.getNodeName(), workspacesInfo);
    }

    public boolean containsBuildWithId(String id) {
        for (DiskUsageBuildInformation inf : this.buildDiskUsage) {
            if (!inf.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public void loadAllBuilds() throws IOException {
        this.load();
        int loadedBuildInformation = this.buildDiskUsage.size();
        if (loadedBuildInformation >= this.numberOfBuildFolders()) {
            return;
        }
        AbstractProject project = (AbstractProject)this.job;
        RunList list = project.getBuilds();
        this.buildDiskUsage = new CopyOnWriteArraySet<DiskUsageBuildInformation>();
        for (Run run : list) {
            if (!(run instanceof AbstractBuild) || this.containsBuildWithId(run.getId())) continue;
            AbstractBuild build = (AbstractBuild)run;
            FilePath workspace = build.getWorkspace();
            Node node = build.getBuiltOn();
            if (workspace != null && node != null) {
                this.putAgentWorkspaceSize(node, workspace.getRemote(), 0L);
            }
            DiskUsageBuildInformation information = new DiskUsageBuildInformation(build.getId(), build.getTimeInMillis(), build.number, 0L);
            this.addBuildInformation(information, build);
        }
        this.allBuildsLoaded = true;
        DiskUsageProperty property = (DiskUsageProperty)this.job.getProperty(DiskUsageProperty.class);
        property.checkWorkspaces(true);
        this.save();
    }

    public synchronized void load() {
        XmlFile file = this.getConfigFile();
        if (!file.getFile().exists()) {
            return;
        }
        try {
            file.unmarshal((Object)this);
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Failed to load " + String.valueOf(file), e);
        }
    }

    public DiskUsageBuildInformation getDiskUsageBuildInformation(int number) {
        for (DiskUsageBuildInformation information : this.buildDiskUsage) {
            if (information.getNumber() != number) continue;
            return information;
        }
        return null;
    }

    public void addBuildInformation(DiskUsageBuildInformation info, @Nullable AbstractBuild build) {
        if (!this.containsBuildWithId(info.getId())) {
            this.buildDiskUsage.add(info);
            if (build == null) {
                return;
            }
            FilePath workspace = build.getWorkspace();
            Node node = build.getBuiltOn();
            if (workspace != null && node != null) {
                this.putAgentWorkspaceSize(node, workspace.getRemote(), 0L);
            }
        }
    }

    private void removeDeletedBuilds() {
        for (DiskUsageBuildInformation information : this.buildDiskUsage) {
            File buildDir = new File(Jenkins.get().getBuildDirFor(this.job), information.getId());
            if (buildDir.exists()) continue;
            this.buildDiskUsage.remove(information);
        }
    }
}

