/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.disk_usage;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.AperiodicWork;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.TaskListener;
import hudson.plugins.disk_usage.DiskUsageCalculation;
import hudson.plugins.disk_usage.DiskUsagePlugin;
import hudson.plugins.disk_usage.DiskUsageUtil;
import hudson.scheduler.CronTab;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import jenkins.model.Jenkins;

@Extension
public class JobWithoutBuildsDiskUsageCalculation
extends DiskUsageCalculation {
    private static DiskUsageCalculation currentTask;

    public JobWithoutBuildsDiskUsageCalculation() {
        super("Calculation of job directories (without builds)");
    }

    public void execute(TaskListener listener) throws IOException, InterruptedException {
        DiskUsagePlugin plugin = (DiskUsagePlugin)Jenkins.get().getPlugin(DiskUsagePlugin.class);
        if (plugin == null) {
            return;
        }
        if (!this.isCancelled() && this.startExecution()) {
            try {
                Jenkins itemGroup = Jenkins.get();
                ArrayList<AbstractProject> items = new ArrayList<AbstractProject>(DiskUsageUtil.getAllProjects((ItemGroup<? extends Item>)itemGroup));
                for (Object e : items) {
                    AbstractProject project;
                    if (!(e instanceof AbstractProject) || (project = (AbstractProject)e).isBuilding()) continue;
                    try {
                        DiskUsageUtil.calculateDiskUsageForProject(project);
                    }
                    catch (Exception ex) {
                        this.logger.log(Level.WARNING, "Error when recording disk usage for " + project.getName(), ex);
                    }
                }
                if (plugin.getConfiguration().warnAboutAllJobsExceetedSize()) {
                    DiskUsageUtil.controlAllJobsExceedSize();
                }
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Error when recording disk usage for jobs.", e);
            }
        } else if (plugin.getConfiguration().isCalculationJobsEnabled()) {
            this.logger.log(Level.FINER, "Calculation of jobs is already in progress.");
        } else {
            this.logger.log(Level.FINER, "Calculation of jobs is disabled.");
        }
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public AperiodicWork getNewInstance() {
        if (currentTask != null) {
            currentTask.cancel();
        } else {
            this.cancel();
        }
        currentTask = new JobWithoutBuildsDiskUsageCalculation();
        return currentTask;
    }

    @Override
    public CronTab getCronTab() {
        DiskUsagePlugin plugin = (DiskUsagePlugin)Jenkins.get().getPlugin(DiskUsagePlugin.class);
        if (plugin == null) {
            return null;
        }
        String cron = plugin.getConfiguration().getCountIntervalForJobs();
        return new CronTab(cron);
    }

    @Override
    public DiskUsageCalculation getLastTask() {
        return currentTask;
    }

    private boolean startExecution() {
        DiskUsagePlugin plugin = (DiskUsagePlugin)Jenkins.get().getPlugin(DiskUsagePlugin.class);
        if (plugin == null || !plugin.getConfiguration().isCalculationJobsEnabled()) {
            return false;
        }
        return !this.isExecutingMoreThenOneTimes();
    }
}

