/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.disk_usage;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.AperiodicWork;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.TransientProjectActionFactory;
import hudson.plugins.disk_usage.BuildDiskUsageCalculationThread;
import hudson.plugins.disk_usage.DiskUsageOvearallGraphGenerator;
import hudson.plugins.disk_usage.DiskUsageUtil;
import hudson.plugins.disk_usage.JobWithoutBuildsDiskUsageCalculation;
import hudson.plugins.disk_usage.Messages;
import hudson.plugins.disk_usage.ProjectDiskUsageAction;
import hudson.plugins.disk_usage.WorkspaceDiskUsageCalculationThread;
import hudson.scheduler.CronTab;
import hudson.security.Permission;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class DiskUsageProjectActionFactory
extends TransientProjectActionFactory
implements Describable<DiskUsageProjectActionFactory> {
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public Collection<? extends Action> createFor(AbstractProject job) {
        ProjectDiskUsageAction action = new ProjectDiskUsageAction(job);
        return Collections.singleton(action);
    }

    public Descriptor<DiskUsageProjectActionFactory> getDescriptor() {
        return DESCRIPTOR;
    }

    public static class DescriptorImpl
    extends Descriptor<DiskUsageProjectActionFactory> {
        private String countIntervalBuilds = "0 */6 * * *";
        private boolean calculationBuilds = true;
        private String countIntervalJobs = "0 */6 * * *";
        private boolean calculationJobs = true;
        private String countIntervalWorkspace = "0 */6 * * *";
        private boolean calculationWorkspace = true;
        private boolean checkWorkspaceOnSlave;
        private String email;
        private String jobSize;
        private String buildSize;
        private String allJobsSize;
        private String jobWorkspaceExceedSize;
        private boolean showFreeSpaceForJobDirectory = true;
        private List<String> excludedJobs = new ArrayList<String>();
        private Long diskUsageBuilds = 0L;
        private Long diskUsageJobsWithoutBuilds = 0L;
        private Long diskUsageWorkspaces = 0L;
        private Long diskUsageLockedBuilds = 0L;
        private boolean showGraph = true;
        private int historyLength = 183;
        List<DiskUsageOvearallGraphGenerator.DiskUsageRecord> history = new LinkedList<DiskUsageOvearallGraphGenerator.DiskUsageRecord>(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean add(DiskUsageOvearallGraphGenerator.DiskUsageRecord e) {
                boolean ret = super.add(e);
                if (ret && this.size() > historyLength) {
                    this.removeRange(0, this.size() - historyLength);
                }
                return ret;
            }
        };
        private int timeoutWorkspace = 5;

        public DescriptorImpl() {
            this.load();
        }

        public Long getCashedGlobalBuildsDiskUsage() {
            return this.diskUsageBuilds;
        }

        public Long getCashedGlobalJobsDiskUsage() {
            return this.diskUsageBuilds + this.diskUsageJobsWithoutBuilds;
        }

        public Long getCashedGlobalJobsWithoutBuildsDiskUsage() {
            return this.diskUsageJobsWithoutBuilds;
        }

        public Long getCashedGlobalLockedBuildsDiskUsage() {
            return this.diskUsageLockedBuilds;
        }

        public Long getCashedGlobalWorkspacesDiskUsage() {
            return this.diskUsageWorkspaces;
        }

        public Long getJobWorkspaceExceedSize() {
            return DiskUsageUtil.getSizeInBytes(this.jobWorkspaceExceedSize);
        }

        public String getJobWorkspaceExceedSizeInString() {
            return this.jobWorkspaceExceedSize;
        }

        public boolean isShowGraph() {
            return this.showGraph;
        }

        public void setShowGraph(Boolean showGraph) {
            this.showGraph = showGraph;
        }

        public int getHistoryLength() {
            return this.historyLength;
        }

        public void setHistoryLength(Integer historyLength) {
            this.historyLength = historyLength;
        }

        public List<DiskUsageOvearallGraphGenerator.DiskUsageRecord> getHistory() {
            return this.history;
        }

        public String getCountIntervalForBuilds() {
            return this.countIntervalBuilds;
        }

        public String getCountIntervalForJobs() {
            return this.countIntervalJobs;
        }

        public String getCountIntervalForWorkspaces() {
            return this.countIntervalWorkspace;
        }

        @Deprecated(forRemoval=true)
        public boolean getCheckWorkspaceOnSlave() {
            return this.getCheckWorkspaceOnAgent();
        }

        public boolean getCheckWorkspaceOnAgent() {
            return this.checkWorkspaceOnSlave;
        }

        @Deprecated(forRemoval=true)
        public void setCheckWorkspaceOnSlave(boolean check) {
            this.checkWorkspaceOnSlave = check;
        }

        public void setCheckWorkspaceOnAgent(boolean check) {
            this.checkWorkspaceOnSlave = check;
        }

        public void setExcludedJobs(List<String> excludedJobs) {
            this.excludedJobs = excludedJobs;
        }

        public boolean isCalculationWorkspaceEnabled() {
            return this.calculationWorkspace;
        }

        public boolean isCalculationBuildsEnabled() {
            return this.calculationBuilds;
        }

        public boolean isCalculationJobsEnabled() {
            return this.calculationJobs;
        }

        public boolean warnAboutJobWorkspaceExceedSize() {
            return this.jobWorkspaceExceedSize != null;
        }

        public boolean warnAboutAllJobsExceetedSize() {
            return this.allJobsSize != null;
        }

        public boolean warnAboutBuildExceetedSize() {
            return this.buildSize != null;
        }

        public boolean warnAboutJobExceetedSize() {
            return this.jobSize != null;
        }

        public String getEmailAddress() {
            return this.email;
        }

        public boolean warningAboutExceededSize() {
            return this.email != null;
        }

        public Long getAllJobsExceedSize() {
            return DiskUsageUtil.getSizeInBytes(this.allJobsSize);
        }

        public Long getBuildExceedSize() {
            return DiskUsageUtil.getSizeInBytes(this.buildSize);
        }

        public Long getJobExceedSize() {
            return DiskUsageUtil.getSizeInBytes(this.jobSize);
        }

        public String getAllJobsExceedSizeInString() {
            return this.allJobsSize;
        }

        public String getBuildExceedSizeInString() {
            return this.buildSize;
        }

        public String getJobExceedSizeInString() {
            return this.jobSize;
        }

        public boolean addHistory(DiskUsageOvearallGraphGenerator.DiskUsageRecord e) {
            boolean ok = this.history.add(e);
            this.save();
            return ok;
        }

        public void enableBuildsDiskUsageCalculation() {
            this.calculationBuilds = true;
        }

        public void disableBuildsDiskUsageCalculation() {
            this.calculationBuilds = false;
        }

        public void enableJobsDiskUsageCalculation() {
            this.calculationJobs = true;
        }

        public void disableJobsDiskUsageCalculation() {
            this.calculationJobs = false;
        }

        public void enableWorkspacesDiskUsageCalculation() {
            this.calculationWorkspace = true;
        }

        public void disableWorkspacesDiskUsageCalculation() {
            this.calculationWorkspace = false;
        }

        public String getUnit(String unit) {
            if (unit == null) {
                return null;
            }
            return unit.split(" ")[1];
        }

        public String getValue(String size) {
            if (size == null) {
                return null;
            }
            return size.split(" ")[0];
        }

        @NonNull
        public String getDisplayName() {
            return Messages.displayName();
        }

        public DiskUsageProjectActionFactory newInstance(StaplerRequest req, @NonNull JSONObject formData) {
            return new DiskUsageProjectActionFactory();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) {
            JSONObject form;
            Jenkins.get().checkPermission(Permission.CONFIGURE);
            try {
                form = req.getSubmittedForm();
            }
            catch (ServletException ex) {
                Logger.getLogger(DiskUsageProjectActionFactory.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            this.checkWorkspaceOnSlave = form.getBoolean("checkWorkspaceOnAgent");
            this.configureBuildsCalculation(form);
            this.configureJobsCalculation(form);
            this.configureWorkspacesCalculation(form);
            String excluded = form.getString("excludedJobs");
            this.excludedJobs = DiskUsageUtil.parseExcludedJobsFromString(excluded);
            if (form.containsKey((Object)"warnings")) {
                JSONObject warnings = form.getJSONObject("warnings");
                this.email = warnings.getString("email");
                if (this.email != null) {
                    this.allJobsSize = warnings.containsKey((Object)"jobsWarning") ? warnings.getJSONObject("jobsWarning").getInt("allJobsSize") + " " + warnings.getJSONObject("jobsWarning").getString("JobsSizeUnit") : null;
                    this.buildSize = warnings.containsKey((Object)"buildWarning") ? warnings.getJSONObject("buildWarning").getInt("buildSize") + " " + warnings.getJSONObject("buildWarning").getString("buildSizeUnit") : null;
                    this.jobSize = warnings.containsKey((Object)"jobWarning") ? warnings.getJSONObject("jobWarning").getInt("jobSize") + " " + warnings.getJSONObject("jobWarning").getString("jobSizeUnit") : null;
                    this.jobWorkspaceExceedSize = warnings.containsKey((Object)"workspaceWarning") ? warnings.getJSONObject("workspaceWarning").getInt("jobWorkspaceExceedSize") + " " + warnings.getJSONObject("workspaceWarning").getString("jobWorkspaceExceedSizeUnit") : null;
                }
            }
            this.showGraph = form.getBoolean("showGraph");
            String histlen = req.getParameter("historyLength");
            if (histlen != null && !histlen.isEmpty()) {
                this.historyLength = Integer.parseInt(histlen);
            }
            this.timeoutWorkspace = form.getInt("timeoutWorkspace");
            this.showFreeSpaceForJobDirectory = form.getBoolean("showFreeSpaceForJobDirectory");
            this.save();
            return true;
        }

        public void onRenameJob(String oldName, String newName) {
            if (this.excludedJobs.contains(oldName)) {
                this.excludedJobs.remove(oldName);
                this.excludedJobs.add(newName);
            }
        }

        public void onDeleteJob(AbstractProject<?, ?> project) {
            String name = project.getName();
            this.excludedJobs.remove(name);
        }

        public boolean isExcluded(AbstractProject<?, ?> project) {
            return this.excludedJobs.contains(project.getName());
        }

        public String getExcludedJobsInString() {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (String name : this.excludedJobs) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(name);
            }
            return builder.toString();
        }

        private void configureBuildsCalculation(JSONObject form) {
            boolean oldCalculationBuilds = this.calculationBuilds;
            String oldCountIntervalBuilds = this.countIntervalBuilds;
            this.calculationBuilds = form.containsKey((Object)"calculationBuilds");
            this.countIntervalBuilds = this.calculationBuilds ? form.getJSONObject("calculationBuilds").getString("countIntervalBuilds") : "0 */6 * * *";
            BuildDiskUsageCalculationThread buildCalculation = (BuildDiskUsageCalculationThread)((Object)AperiodicWork.all().get(BuildDiskUsageCalculationThread.class));
            if (!oldCountIntervalBuilds.equals(this.countIntervalBuilds) || oldCalculationBuilds != this.calculationBuilds) {
                buildCalculation.reschedule();
            }
        }

        private FormValidation checkCrons(String cron) {
            try {
                CronTab cronTab = new CronTab(cron);
                String sanity = cronTab.checkSanity();
                if (sanity == null) {
                    return FormValidation.ok();
                }
                return FormValidation.warning((String)sanity);
            }
            catch (IllegalArgumentException e) {
                return FormValidation.error((String)Messages.invalidCrontab(cron));
            }
        }

        public FormValidation doCheckCountIntervalBuilds(@QueryParameter String value) {
            return this.checkCrons(value);
        }

        public FormValidation doCheckCountIntervalJobs(@QueryParameter String value) {
            return this.checkCrons(value);
        }

        public FormValidation doCheckCountIntervalWorkspace(@QueryParameter String value) {
            return this.checkCrons(value);
        }

        private void configureJobsCalculation(JSONObject form) {
            boolean oldCalculationJobs = this.calculationJobs;
            String oldcountIntervalJobs = this.countIntervalJobs;
            this.calculationJobs = form.containsKey((Object)"calculationJobs");
            this.countIntervalJobs = this.calculationJobs ? form.getJSONObject("calculationJobs").getString("countIntervalJobs") : "0 */6 * * *";
            JobWithoutBuildsDiskUsageCalculation jobCalculation = (JobWithoutBuildsDiskUsageCalculation)((Object)AperiodicWork.all().get(JobWithoutBuildsDiskUsageCalculation.class));
            if (!oldcountIntervalJobs.equals(this.countIntervalJobs) || oldCalculationJobs != this.calculationJobs) {
                jobCalculation.reschedule();
            }
        }

        private void configureWorkspacesCalculation(JSONObject form) {
            boolean oldCalculationWorkspace = this.calculationWorkspace;
            String oldCountIntervalWorkspace = this.countIntervalWorkspace;
            this.calculationWorkspace = form.containsKey((Object)"calculationWorkspace");
            this.countIntervalWorkspace = this.calculationWorkspace ? form.getJSONObject("calculationWorkspace").getString("countIntervalWorkspace") : "0 */6 * * *";
            WorkspaceDiskUsageCalculationThread workspaceCalculation = (WorkspaceDiskUsageCalculationThread)((Object)AperiodicWork.all().get(WorkspaceDiskUsageCalculationThread.class));
            if (!oldCountIntervalWorkspace.equals(this.countIntervalWorkspace) || oldCalculationWorkspace != this.calculationWorkspace) {
                workspaceCalculation.reschedule();
            }
        }

        public int getTimeoutWorkspace() {
            return this.timeoutWorkspace;
        }

        public boolean getShowFreeSpaceForJobDirectory() {
            return this.showFreeSpaceForJobDirectory;
        }

        public void setTimeoutWorkspace(Integer timeoutWorkspace) {
            this.timeoutWorkspace = timeoutWorkspace;
        }
    }
}

