/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.disk_usage;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.plugins.disk_usage.BuildDiskUsageAction;
import hudson.plugins.disk_usage.DiskUsageBuildInformation;
import hudson.plugins.disk_usage.DiskUsageProperty;
import hudson.plugins.disk_usage.DiskUsageUtil;
import hudson.plugins.disk_usage.project.DiskUsagePostBuildCalculation;

@Extension
public class DiskUsageBuildListener
extends RunListener<AbstractBuild<?, ?>> {
    public void onCompleted(AbstractBuild<?, ?> build, @NonNull TaskListener listener) {
        Long diskUsage = ((BuildDiskUsageAction)build.getAction(BuildDiskUsageAction.class)).getDiskUsage();
        if (build.getProject().getPublishersList().get(DiskUsagePostBuildCalculation.class) == null || diskUsage == 0L) {
            DiskUsageUtil.calculationDiskUsageOfBuild(build, listener);
        } else {
            listener.getLogger().println("Skipping calculation of disk usage, it was already done in post build step.");
        }
    }

    public void onDeleted(AbstractBuild<?, ?> build) {
        DiskUsageBuildInformation information;
        DiskUsageProperty property = (DiskUsageProperty)build.getProject().getProperty(DiskUsageProperty.class);
        if (property == null) {
            DiskUsageUtil.addProperty((Item)build.getProject());
            property = (DiskUsageProperty)build.getProject().getProperty(DiskUsageProperty.class);
        }
        if ((information = property.getDiskUsageBuildInformation(build.getId())) != null) {
            property.getDiskUsage().removeBuild(information);
            property.getDiskUsage().save();
        }
    }

    public void onStarted(AbstractBuild<?, ?> build, TaskListener listener) {
        DiskUsageBuildInformation information;
        DiskUsageProperty property = (DiskUsageProperty)build.getProject().getProperty(DiskUsageProperty.class);
        if (property == null) {
            DiskUsageUtil.addProperty((Item)build.getProject());
            property = (DiskUsageProperty)build.getProject().getProperty(DiskUsageProperty.class);
        }
        if ((information = property.getDiskUsageBuildInformation(build.getId())) == null) {
            property.getDiskUsage().addBuildInformation(new DiskUsageBuildInformation(build.getId(), build.getTimeInMillis(), build.getNumber(), 0L), build);
        }
    }
}

