/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.descriptionsetter;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixProject;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.plugins.descriptionsetter.DescriptionSetterHelper;
import hudson.plugins.descriptionsetter.Messages;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.io.ObjectStreamException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public class DescriptionSetterPublisher
extends Recorder
implements MatrixAggregatable {
    private final String regexp;
    private final String regexpForFailed;
    private final String description;
    private final String descriptionForFailed;
    private final boolean setForMatrix;
    private final boolean appendMode;
    @Deprecated
    private transient boolean setForFailed = false;
    @Deprecated
    private transient boolean explicitNotRegexp = false;

    @DataBoundConstructor
    public DescriptionSetterPublisher(String regexp, String regexpForFailed, String description, String descriptionForFailed, boolean setForMatrix, boolean appendMode) {
        this.regexp = regexp;
        this.regexpForFailed = regexpForFailed;
        this.description = Util.fixEmptyAndTrim((String)description);
        this.descriptionForFailed = Util.fixEmptyAndTrim((String)descriptionForFailed);
        this.setForMatrix = setForMatrix;
        this.appendMode = appendMode;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        Result result = build.getResult();
        boolean useUnstable = (this.regexpForFailed != null || this.descriptionForFailed != null) && result != null && result.isWorseThan(Result.UNSTABLE);
        return DescriptionSetterHelper.setDescription(build, listener, useUnstable ? this.regexpForFailed : this.regexp, useUnstable ? this.descriptionForFailed : this.description, this.appendMode);
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.explicitNotRegexp) {
            return new DescriptionSetterPublisher(null, null, this.regexp, this.setForFailed ? this.regexpForFailed : null, false, false);
        }
        return this;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Deprecated
    public boolean isExplicitNotRegexp() {
        return this.explicitNotRegexp;
    }

    public String getRegexp() {
        return this.regexp;
    }

    @Deprecated
    public boolean isSetForFailed() {
        return this.setForFailed;
    }

    public String getRegexpForFailed() {
        return this.regexpForFailed;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescriptionForFailed() {
        return this.descriptionForFailed;
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        if (!this.isSetForMatrix()) {
            return null;
        }
        return new MatrixAggregator(build, launcher, listener){

            public boolean endRun(MatrixRun run) throws InterruptedException, IOException {
                if (this.build.getDescription() == null && run.getDescription() != null) {
                    this.build.setDescription(run.getDescription());
                } else if (this.build.getDescription() != null && run.getDescription() != null) {
                    String oldDescr = this.build.getDescription();
                    String formatter = Jenkins.get().getMarkupFormatter().getClass().getName();
                    String htmlBreak = formatter.contains("HtmlMarkup") ? "<br>" : " ";
                    String newDescr = oldDescr + htmlBreak + run.getDescription();
                    this.build.setDescription(newDescr);
                }
                return true;
            }
        };
    }

    public boolean isSetForMatrix() {
        return this.setForMatrix;
    }

    public boolean isAppendMode() {
        return this.appendMode;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(DescriptionSetterPublisher.class);
        }

        public String getDisplayName() {
            return Messages.DescriptionSetter_DisplayName();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public Publisher newInstance(StaplerRequest2 req, @NonNull JSONObject formData) throws Descriptor.FormException {
            if (req == null) {
                return null;
            }
            return (Publisher)req.bindJSON(DescriptionSetterPublisher.class, formData);
        }

        public boolean isMatrixProject(AbstractProject project) {
            return project instanceof MatrixProject;
        }
    }
}

