/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.descriptionsetter;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.ParametersAction;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.plugins.descriptionsetter.DescriptionSetterAction;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;

public class DescriptionSetterHelper {
    private static final String LOG_PREFIX = "[description-setter]";

    public static boolean setDescription(AbstractBuild<?, ?> build, BuildListener listener, String regexp, String description) throws InterruptedException {
        return DescriptionSetterHelper.setDescription(build, listener, regexp, description, true);
    }

    public static boolean setDescription(AbstractBuild<?, ?> build, BuildListener listener, String regexp, String description, boolean appendMode) throws InterruptedException {
        try {
            String htmlBreak;
            String result = null;
            Matcher matcher = DescriptionSetterHelper.parseLog(build, regexp);
            if (matcher != null) {
                result = DescriptionSetterHelper.getExpandedDescription(matcher, description);
                result = build.getEnvironment((TaskListener)listener).expand(result);
            } else if (regexp == null && description != null) {
                result = description;
            }
            if (result == null) {
                listener.getLogger().println("[description-setter] Could not determine description.");
                return true;
            }
            result = DescriptionSetterHelper.urlify(result);
            build.addAction((Action)new DescriptionSetterAction(result));
            String formatter = Jenkins.get().getMarkupFormatter().getClass().getName();
            String string = htmlBreak = formatter.contains("HtmlMarkup") ? "<br>" : " ";
            if (build.getDescription() == null) {
                build.setDescription(result);
            } else {
                build.setDescription((String)(appendMode ? build.getDescription() + htmlBreak : "") + result);
            }
            DescriptionSetterHelper.setEnvironmentVariable(result, build);
            listener.getLogger().println("[description-setter] Description set: " + result);
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("[description-setter] Error while parsing logs for description-setter"));
        }
        return true;
    }

    private static void setEnvironmentVariable(String result, AbstractBuild<?, ?> build) {
        ArrayList<StringParameterValue> params = new ArrayList<StringParameterValue>();
        params.add(new StringParameterValue("DESCRIPTION_SETTER_DESCRIPTION", result));
        build.addAction((Action)new ParametersAction(params));
    }

    private static Matcher parseLog(AbstractBuild<?, ?> build, String regexp) throws IOException {
        if (regexp == null) {
            return null;
        }
        Pattern pattern = Pattern.compile(regexp);
        try (BufferedReader reader = new BufferedReader(build.getLogReader());){
            String line;
            while ((line = reader.readLine()) != null) {
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find()) continue;
                Matcher matcher2 = matcher;
                return matcher2;
            }
        }
        return null;
    }

    private static String getExpandedDescription(Matcher matcher, String description) {
        String result = description;
        if (result == null) {
            result = matcher.groupCount() == 0 ? "\\0" : "\\1";
        }
        for (int i = matcher.groupCount(); i >= 0; --i) {
            result = result.replace("\\" + i, matcher.group(i) == null ? "" : matcher.group(i));
        }
        return result;
    }

    private static String urlify(String text) {
        try {
            new URL(text);
            return "<a href=\"%s\">%s</a>".formatted(text, text);
        }
        catch (MalformedURLException e) {
            return text;
        }
    }
}

