/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.descriptionsetter;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.plugins.descriptionsetter.DescriptionSetterHelper;
import hudson.plugins.descriptionsetter.Messages;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public class DescriptionSetterBuilder
extends Builder {
    private final String regexp;
    private final String description;
    private final boolean appendMode;

    @DataBoundConstructor
    public DescriptionSetterBuilder(String regexp, String description, boolean appendMode) {
        this.regexp = regexp;
        this.description = Util.fixEmptyAndTrim((String)description);
        this.appendMode = appendMode;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        return DescriptionSetterHelper.setDescription(build, listener, this.regexp, this.description, this.appendMode);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getRegexp() {
        return this.regexp;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getAppendMode() {
        return this.appendMode;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            super(DescriptionSetterBuilder.class);
        }

        public String getDisplayName() {
            return Messages.DescriptionSetter_DisplayName();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public Builder newInstance(StaplerRequest2 req, @NonNull JSONObject formData) throws Descriptor.FormException {
            if (req == null) {
                return null;
            }
            return (Builder)req.bindJSON(DescriptionSetterBuilder.class, formData);
        }
    }
}

