/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.deploy;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.deploy.ContainerAdapter;
import hudson.plugins.deploy.LoggerImpl;
import hudson.plugins.deploy.Messages;
import hudson.remoting.VirtualChannel;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.EAR;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.generic.ContainerFactory;
import org.codehaus.cargo.generic.DefaultContainerFactory;
import org.codehaus.cargo.generic.configuration.ConfigurationFactory;
import org.codehaus.cargo.generic.configuration.DefaultConfigurationFactory;
import org.codehaus.cargo.generic.deployer.DefaultDeployerFactory;
import org.codehaus.cargo.generic.deployer.DeployerFactory;
import org.codehaus.cargo.util.log.Logger;

public abstract class CargoContainerAdapter
extends ContainerAdapter
implements Serializable {
    private static final long serialVersionUID = 5369849174353254743L;

    protected abstract String getContainerId();

    protected abstract void configure(Configuration var1, EnvVars var2, VariableResolver<String> var3);

    protected Container getContainer(ConfigurationFactory configFactory, ContainerFactory containerFactory, String id, EnvVars envVars, VariableResolver<String> resolver) {
        Configuration config = configFactory.createConfiguration(id, ContainerType.REMOTE, ConfigurationType.RUNTIME);
        this.configure(config, envVars, resolver);
        return containerFactory.createContainer(id, ContainerType.REMOTE, config);
    }

    protected void deploy(DeployerFactory deployerFactory, TaskListener listener, Container container, File f, String contextPath) {
        Deployer deployer = deployerFactory.createDeployer(container);
        listener.getLogger().println("[DeployPublisher][INFO] Deploying " + String.valueOf(f) + " to container " + container.getName() + " with context " + contextPath);
        deployer.setLogger((Logger)new LoggerImpl(listener.getLogger()));
        String extension = FilenameUtils.getExtension((String)f.getAbsolutePath());
        if ("WAR".equalsIgnoreCase(extension)) {
            WAR war = this.createWAR(f);
            if (!StringUtils.isEmpty((String)contextPath)) {
                war.setContext(contextPath);
            }
            deployer.redeploy((Deployable)war);
        } else if ("EAR".equalsIgnoreCase(extension)) {
            EAR ear = this.createEAR(f);
            deployer.redeploy((Deployable)ear);
        } else {
            throw new RuntimeException("Extension File Error. Unsupported: .\"" + extension + "\"");
        }
    }

    protected WAR createWAR(File deployableFile) {
        return new WAR(deployableFile.getAbsolutePath());
    }

    protected String expandVariable(EnvVars envVars, VariableResolver<String> resolver, String variable) {
        return Util.replaceMacro((String)envVars.expand(variable), resolver);
    }

    protected EAR createEAR(File deployableFile) {
        return new EAR(deployableFile.getAbsolutePath());
    }

    @Override
    public void redeployFile(FilePath war, String contextPath, Run<?, ?> run, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        EnvVars envVars = new EnvVars();
        if (run instanceof AbstractBuild) {
            AbstractBuild build = (AbstractBuild)run;
            envVars = build.getEnvironment(listener);
        }
        war.act((FilePath.FileCallable)new DeployCallable(this, this.getContainerId(), envVars, listener, contextPath));
    }

    public static class DeployCallable
    extends MasterToSlaveFileCallable<Boolean> {
        private static final long serialVersionUID = 2695944029141469818L;
        private CargoContainerAdapter adapter;
        private String containerId;
        private TaskListener listener;
        private String contextPath;
        private EnvVars envVars;

        public DeployCallable(CargoContainerAdapter adapter, String containerId, EnvVars envVars, TaskListener listener, String contextPath) {
            this.adapter = adapter;
            this.containerId = containerId;
            this.envVars = envVars;
            this.listener = listener;
            this.contextPath = contextPath;
        }

        public Boolean invoke(File f, VirtualChannel channel) throws IOException {
            if (!f.exists()) {
                this.listener.error(Messages.DeployPublisher_NoSuchFile(f));
                return true;
            }
            ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
            DefaultDeployerFactory deployerFactory = new DefaultDeployerFactory(cl);
            DefaultConfigurationFactory configFactory = new DefaultConfigurationFactory(cl);
            DefaultContainerFactory containerFactory = new DefaultContainerFactory(cl);
            VariableResolver.ByMap resolver = new VariableResolver.ByMap((Map)this.envVars);
            Container container = this.adapter.getContainer((ConfigurationFactory)configFactory, (ContainerFactory)containerFactory, this.containerId, this.envVars, (VariableResolver<String>)resolver);
            this.adapter.deploy((DeployerFactory)deployerFactory, this.listener, container, f, Util.replaceMacro((String)this.envVars.expand(this.contextPath), (VariableResolver)resolver));
            return true;
        }
    }
}

