// CHECKSTYLE:OFF

package hudson.plugins.deploy;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code DeployPublisher.BadFormedUrl}: {@code Invalid url syntax}.
     * 
     * @return
     *     {@code Invalid url syntax}
     */
    public static String DeployPublisher_BadFormedUrl() {
        return holder.format("DeployPublisher.BadFormedUrl");
    }

    /**
     * Key {@code DeployPublisher.BadFormedUrl}: {@code Invalid url syntax}.
     * 
     * @return
     *     {@code Invalid url syntax}
     */
    public static Localizable _DeployPublisher_BadFormedUrl() {
        return new Localizable(holder, "DeployPublisher.BadFormedUrl");
    }

    /**
     * Key {@code DeployPublisher.NoSuchFile}: {@code No such file exists:
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such file exists: {0}}
     */
    public static String DeployPublisher_NoSuchFile(Object arg0) {
        return holder.format("DeployPublisher.NoSuchFile", arg0);
    }

    /**
     * Key {@code DeployPublisher.NoSuchFile}: {@code No such file exists:
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such file exists: {0}}
     */
    public static Localizable _DeployPublisher_NoSuchFile(Object arg0) {
        return new Localizable(holder, "DeployPublisher.NoSuchFile", arg0);
    }

    /**
     * Key {@code DeployPublisher.DisplayName}: {@code Deploy war/ear to a
     * container}.
     * 
     * @return
     *     {@code Deploy war/ear to a container}
     */
    public static String DeployPublisher_DisplayName() {
        return holder.format("DeployPublisher.DisplayName");
    }

    /**
     * Key {@code DeployPublisher.DisplayName}: {@code Deploy war/ear to a
     * container}.
     * 
     * @return
     *     {@code Deploy war/ear to a container}
     */
    public static Localizable _DeployPublisher_DisplayName() {
        return new Localizable(holder, "DeployPublisher.DisplayName");
    }

}
