/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.deploy;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.deploy.ContainerAdapterDescriptor;
import hudson.plugins.deploy.DefaultCargoContainerAdapterImpl;
import hudson.plugins.deploy.DeployPublisher;
import hudson.util.Scrambler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class PasswordProtectedAdapterCargo
extends DefaultCargoContainerAdapterImpl {
    private static final long serialVersionUID = 8002030181042078933L;
    @Deprecated
    private String passwordScrambled;
    @XStreamOmitField
    private String userName;
    @XStreamOmitField
    private String password;
    @CheckForNull
    private String credentialsId;

    public PasswordProtectedAdapterCargo(String credentialsId) {
        this.credentialsId = Util.fixEmpty((String)credentialsId);
    }

    @Restricted(value={DoNotUse.class})
    @Deprecated
    public PasswordProtectedAdapterCargo(String userName, String password) {
        this.userName = userName;
        this.password = password;
        this.migrateCredentials(new ArrayList<StandardUsernamePasswordCredentials>());
    }

    @Override
    public void redeployFile(FilePath war, String aContextPath, Run<?, ?> run, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        this.loadCredentials(run.getParent());
        super.redeployFile(war, aContextPath, run, launcher, listener);
    }

    public void loadCredentials(Job<?, ?> job) {
        StandardUsernamePasswordCredentials credentials = ContainerAdapterDescriptor.lookupCredentials(job, this.getUrl(), this.credentialsId);
        if (credentials != null) {
            CredentialsProvider.track(job, (Credentials)credentials);
            this.userName = credentials.getUsername();
            this.password = credentials.getPassword().getPlainText();
        } else {
            Logger.getLogger(DeployPublisher.class.getName()).log(Level.WARNING, "Tried to load DeployPublisher credentials for credentials ID " + this.credentialsId + " but couldn't find them!");
        }
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DefaultCargoContainerAdapterImpl.Property(value="cargo.remote.username")
    public String getUsername() {
        return this.userName;
    }

    @DefaultCargoContainerAdapterImpl.Property(value="cargo.remote.password")
    @Restricted(value={NoExternalUse.class})
    public String getPassword() {
        return this.password;
    }

    public String getUrl() {
        return null;
    }

    public boolean migrateCredentials(List<StandardUsernamePasswordCredentials> generated) {
        if (this.credentialsId == null) {
            boolean validCredentials;
            if (this.passwordScrambled != null) {
                this.password = Scrambler.descramble((String)this.passwordScrambled);
            }
            StandardUsernamePasswordCredentials newCredentials = null;
            for (StandardUsernamePasswordCredentials c : generated) {
                if (!c.getUsername().equals(this.userName) || !c.getPassword().getPlainText().equals(this.password)) continue;
                newCredentials = c;
            }
            boolean bl = validCredentials = newCredentials != null;
            if (!validCredentials) {
                try {
                    newCredentials = new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, null, "Generated deploy-plugin credentials for " + this.getContainerId(), this.userName, this.password);
                }
                catch (Descriptor.FormException e) {
                    Logger.getLogger(DeployPublisher.class.getName()).log(Level.SEVERE, "deploy-plugin credentials could not be created!");
                    return false;
                }
                try {
                    ((CredentialsStore)CredentialsProvider.lookupStores((ModelObject)Jenkins.get()).iterator().next()).addCredentials(Domain.global(), (Credentials)newCredentials);
                    generated.add(newCredentials);
                    validCredentials = true;
                    Logger.getLogger(DeployPublisher.class.getName()).log(Level.INFO, "credentials were generated and added to config");
                }
                catch (IOException e) {
                    Logger.getLogger(DeployPublisher.class.getName()).log(Level.SEVERE, "credentials were generated with id " + newCredentials.getId() + " but could not be stored.  Please create valid credentials or fix this job.");
                    validCredentials = false;
                }
            }
            if (validCredentials) {
                this.userName = null;
                this.password = null;
                this.passwordScrambled = null;
            }
            this.credentialsId = newCredentials.getId();
            return validCredentials;
        }
        return true;
    }
}

