/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.deploy;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Items;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.ItemListener;
import hudson.plugins.deploy.ContainerAdapter;
import hudson.plugins.deploy.ContainerAdapterDescriptor;
import hudson.plugins.deploy.Messages;
import hudson.plugins.deploy.PasswordProtectedAdapterCargo;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import jenkins.util.io.FileBoolean;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DeployPublisher
extends Notifier
implements SimpleBuildStep,
Serializable {
    private static final long serialVersionUID = 2244731062465136983L;
    private List<ContainerAdapter> adapters;
    private String contextPath = "";
    private String war;
    private boolean onFailure = true;
    public final ContainerAdapter adapter = null;

    @DataBoundConstructor
    public DeployPublisher(List<ContainerAdapter> adapters, String war) {
        this.adapters = adapters;
        this.war = war;
    }

    @Deprecated
    public DeployPublisher(List<ContainerAdapter> adapters, String war, String contextPath, boolean onFailure) {
        this.adapters = adapters;
        this.war = war;
    }

    public String getWar() {
        return this.war;
    }

    public boolean isOnFailure() {
        return this.onFailure;
    }

    @DataBoundSetter
    public void setOnFailure(boolean onFailure) {
        this.onFailure = onFailure;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    @DataBoundSetter
    public void setContextPath(String contextPath) {
        this.contextPath = Util.fixEmpty((String)contextPath);
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        Result result = run.getResult();
        if (this.onFailure || result == null || Result.SUCCESS.equals(result)) {
            if (!workspace.exists()) {
                listener.getLogger().println("[DeployPublisher][ERROR] Workspace not found");
                throw new AbortException("Workspace not found");
            }
            EnvVars envVars = new EnvVars();
            if (run instanceof AbstractBuild) {
                AbstractBuild build = (AbstractBuild)run;
                envVars = build.getEnvironment(listener);
            }
            VariableResolver.ByMap resolver = new VariableResolver.ByMap((Map)envVars);
            String warFiles = Util.replaceMacro((String)envVars.expand(this.war), (VariableResolver)resolver);
            FilePath[] wars = workspace.list(warFiles);
            if (wars == null || wars.length == 0) {
                throw new InterruptedException("[DeployPublisher][WARN] No wars found. Deploy aborted. %n");
            }
            listener.getLogger().printf("[DeployPublisher][INFO] Attempting to deploy %d war file(s)%n", wars.length);
            for (FilePath warFile : wars) {
                for (ContainerAdapter containerAdapter : this.adapters) {
                    containerAdapter.redeployFile(warFile, this.contextPath, run, launcher, listener);
                }
            }
        } else {
            listener.getLogger().println("[DeployPublisher][INFO] Build failed, project not deployed");
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public Object readResolve() {
        return this;
    }

    public List<ContainerAdapter> getAdapters() {
        return this.adapters;
    }

    @Restricted(value={NoExternalUse.class})
    @Extension
    public static final class Migrator
    extends ItemListener {
        public void onLoaded() {
            FileBoolean migrated = new FileBoolean(((Object)((Object)this)).getClass(), "migratedCredentials");
            if (migrated.isOn()) {
                return;
            }
            ArrayList<StandardUsernamePasswordCredentials> generatedCredentials = new ArrayList<StandardUsernamePasswordCredentials>();
            for (AbstractProject project : Jenkins.get().getAllItems(AbstractProject.class)) {
                try {
                    DeployPublisher d = (DeployPublisher)project.getPublishersList().get(DeployPublisher.class);
                    if (d == null) continue;
                    boolean modified = false;
                    boolean successful = true;
                    for (ContainerAdapter a : d.getAdapters()) {
                        PasswordProtectedAdapterCargo ppac;
                        if (!(a instanceof PasswordProtectedAdapterCargo) || (ppac = (PasswordProtectedAdapterCargo)a).getCredentialsId() != null) continue;
                        successful &= ppac.migrateCredentials(generatedCredentials);
                        modified = true;
                    }
                    if (!modified) continue;
                    if (successful) {
                        Logger.getLogger(DeployPublisher.class.getName()).log(Level.INFO, "Successfully migrated DeployPublisher in project: {0}", project.getName());
                        project.save();
                        continue;
                    }
                    Logger.getLogger(DeployPublisher.class.getName()).log(Level.SEVERE, "Failed to create credentials and migrate DeployPublisher in project: {0}, please manually add credentials.", project.getName());
                }
                catch (IOException e) {
                    Logger.getLogger(DeployPublisher.class.getName()).log(Level.WARNING, "Migration unsuccessful", e);
                }
            }
            migrated.on();
        }
    }

    @Symbol(value={"deploy"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            Items.XSTREAM2.processAnnotations(PasswordProtectedAdapterCargo.class);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public boolean defaultOnFailure(Object job) {
            return !(job instanceof AbstractProject);
        }

        public String getDisplayName() {
            return Messages.DeployPublisher_DisplayName();
        }

        public List<ContainerAdapterDescriptor> getAdaptersDescriptors() {
            ArrayList<ContainerAdapterDescriptor> r = new ArrayList<ContainerAdapterDescriptor>((Collection<ContainerAdapterDescriptor>)ContainerAdapter.all());
            Collections.sort(r, new Comparator<ContainerAdapterDescriptor>(){

                @Override
                public int compare(ContainerAdapterDescriptor o1, ContainerAdapterDescriptor o2) {
                    return o1.getDisplayName().compareTo(o2.getDisplayName());
                }
            });
            return r;
        }
    }
}

