/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.deploy;

import hudson.EnvVars;
import hudson.plugins.deploy.CargoContainerAdapter;
import hudson.util.VariableResolver;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.beanutils.ConvertUtils;
import org.codehaus.cargo.container.configuration.Configuration;

public abstract class DefaultCargoContainerAdapterImpl
extends CargoContainerAdapter {
    private static final long serialVersionUID = -4399554450872748605L;

    @Override
    public void configure(Configuration config, EnvVars envVars, VariableResolver<String> resolver) {
        for (Field field : this.getClass().getFields()) {
            this.setConfiguration(field, config, envVars, resolver);
        }
        for (AccessibleObject accessibleObject : this.getClass().getMethods()) {
            this.setConfiguration(accessibleObject, config, envVars, resolver);
        }
    }

    private void setConfiguration(AccessibleObject ao, Configuration config, EnvVars envVars, VariableResolver<String> resolver) {
        Property p = ao.getAnnotation(Property.class);
        if (p == null) {
            return;
        }
        try {
            String v = ConvertUtils.convert((Object)this.getPropertyValue(ao));
            if (v != null) {
                if (!v.equals("cargo.remote.password")) {
                    v = this.expandVariable(envVars, resolver, v);
                }
                config.setProperty(p.value(), v);
            }
        }
        catch (Exception e) {
            IllegalAccessError x = new IllegalAccessError();
            x.initCause(e);
            throw x;
        }
    }

    private Object getPropertyValue(AccessibleObject ao) throws Exception {
        if (ao instanceof Field) {
            return ((Field)ao).get(this);
        }
        if (ao instanceof Method) {
            return ((Method)ao).invoke((Object)this, new Object[0]);
        }
        throw new UnsupportedOperationException();
    }

    @Target(value={ElementType.FIELD, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface Property {
        public String value();
    }
}

