/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.deploy.tomcat;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.deploy.PasswordProtectedAdapterCargo;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.tomcat.TomcatWAR;

public abstract class TomcatAdapter
extends PasswordProtectedAdapterCargo {
    private static final long serialVersionUID = 4326184683787248367L;
    public final String url;
    public final String alternativeDeploymentContext;
    private final String path;

    public TomcatAdapter(String url, String credentialsId, String alternativeDeploymentContext, String path) {
        super(credentialsId);
        this.url = url;
        this.path = path;
        this.alternativeDeploymentContext = alternativeDeploymentContext;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public void configure(Configuration config, EnvVars envVars, VariableResolver<String> resolver) {
        super.configure(config, envVars, resolver);
        try {
            if (StringUtils.isNotBlank((String)this.path)) {
                URL managerUrl = new URL(this.expandVariable(envVars, resolver, this.url) + this.expandVariable(envVars, resolver, this.path));
                config.setProperty("cargo.remote.uri", managerUrl.toExternalForm());
            } else {
                URL baseUrl = new URL(this.expandVariable(envVars, resolver, this.url));
                config.setProperty("cargo.protocol", baseUrl.getProtocol());
                config.setProperty("cargo.hostname", baseUrl.getHost());
                config.setProperty("cargo.servlet.port", String.valueOf(baseUrl.getPort()));
            }
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    protected WAR createWAR(File deployableFile) {
        return new TomcatWAR(deployableFile.getAbsolutePath());
    }

    @Override
    public void redeployFile(FilePath war, String aContextPath, Run<?, ?> run, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        String finalContextPath = StringUtils.defaultIfBlank((String)this.alternativeDeploymentContext, (String)aContextPath);
        super.redeployFile(war, finalContextPath, run, launcher, listener);
    }
}

