/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.deploy.glassfish;

import hudson.EnvVars;
import hudson.plugins.deploy.DefaultCargoContainerAdapterImpl;
import hudson.plugins.deploy.PasswordProtectedAdapterCargo;
import hudson.util.VariableResolver;
import org.apache.commons.lang.StringUtils;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.spi.AbstractInstalledLocalContainer;
import org.codehaus.cargo.container.spi.configuration.AbstractRuntimeConfiguration;
import org.codehaus.cargo.container.spi.configuration.AbstractStandaloneLocalConfiguration;
import org.codehaus.cargo.generic.ContainerFactory;
import org.codehaus.cargo.generic.configuration.ConfigurationFactory;

public abstract class GlassFishAdapter
extends PasswordProtectedAdapterCargo {
    private static final long serialVersionUID = 7637381017646912632L;
    public final String home;
    @DefaultCargoContainerAdapterImpl.Property(value="cargo.glassfish.admin.port")
    public final String adminPort;
    @DefaultCargoContainerAdapterImpl.Property(value="cargo.hostname")
    public final String hostname;

    protected GlassFishAdapter(String home, String credentialsId, String adminPort, String hostname) {
        super(credentialsId);
        this.home = home;
        this.adminPort = adminPort;
        this.hostname = hostname;
    }

    @Override
    public String getUrl() {
        return "http://" + StringUtils.defaultIfBlank((String)this.hostname, (String)"localhost") + ":" + this.adminPort;
    }

    @Override
    protected Container getContainer(ConfigurationFactory configFactory, ContainerFactory containerFactory, String id, EnvVars envVars, VariableResolver<String> resolver) {
        if (this.hostname != null) {
            AbstractRuntimeConfiguration config = (AbstractRuntimeConfiguration)configFactory.createConfiguration(id, ContainerType.REMOTE, ConfigurationType.RUNTIME);
            this.configure((Configuration)config, envVars, resolver);
            config.setProperty("cargo.remote.password", this.getPassword());
            return containerFactory.createContainer(id, ContainerType.REMOTE, (Configuration)config);
        }
        AbstractStandaloneLocalConfiguration config = (AbstractStandaloneLocalConfiguration)configFactory.createConfiguration(id, ContainerType.INSTALLED, ConfigurationType.STANDALONE, this.home);
        this.configure((Configuration)config, envVars, resolver);
        AbstractInstalledLocalContainer container = (AbstractInstalledLocalContainer)containerFactory.createContainer(id, ContainerType.INSTALLED, (Configuration)config);
        container.setHome(this.expandVariable(envVars, resolver, this.home));
        return container;
    }
}

