/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.deploy;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.queue.Tasks;
import hudson.plugins.deploy.ContainerAdapter;
import hudson.plugins.deploy.Messages;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;

public abstract class ContainerAdapterDescriptor
extends Descriptor<ContainerAdapter> {
    protected ContainerAdapterDescriptor(Class<? extends ContainerAdapter> clazz) {
        super(clazz);
    }

    protected ContainerAdapterDescriptor() {
    }

    protected static StandardUsernamePasswordCredentials lookupCredentials(@CheckForNull Item project, String url, String credentialId) {
        return credentialId == null ? null : (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)project, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)url).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialId));
    }

    @Restricted(value={NoExternalUse.class})
    public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project, @QueryParameter String url, @QueryParameter String credentialsId) {
        if (project == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER) || project != null && !project.hasPermission(Item.EXTENDED_READ)) {
            return new StandardListBoxModel().includeCurrentValue(credentialsId);
        }
        return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(project instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)project)) : ACL.SYSTEM, project, StandardUsernameCredentials.class, URIRequirementBuilder.fromUri((String)url).build(), CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class)).includeCurrentValue(credentialsId);
    }

    public FormValidation doCheckCredentialsId(@AncestorInPath Item project, @QueryParameter String url, @QueryParameter String value) {
        if (project == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER) || project != null && !project.hasPermission(Item.EXTENDED_READ)) {
            return FormValidation.ok();
        }
        if ((value = Util.fixEmptyAndTrim((String)value)) == null) {
            return FormValidation.ok();
        }
        for (ListBoxModel.Option o : CredentialsProvider.listCredentials(StandardUsernameCredentials.class, (Item)project, (Authentication)(project instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)project)) : ACL.SYSTEM), (List)URIRequirementBuilder.fromUri((String)url).build(), (CredentialsMatcher)CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class))) {
            if (!StringUtils.equals((String)value, (String)o.value)) continue;
            return FormValidation.ok();
        }
        return FormValidation.warning((String)("Cannot find any credentials with id " + value));
    }

    public FormValidation doCheckUrl(@QueryParameter String value) throws IOException {
        if (value != null && value.length() > 0) {
            try {
                new URL(value);
            }
            catch (Exception e) {
                return FormValidation.warning((String)Messages.DeployPublisher_BadFormedUrl());
            }
        }
        return FormValidation.ok();
    }
}

