/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.DependencyCheck;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang3.ArrayUtils;
import org.jenkinsci.plugins.DependencyCheck.AbstractThresholdPublisher;
import org.jenkinsci.plugins.DependencyCheck.Messages;
import org.jenkinsci.plugins.DependencyCheck.ResultAction;
import org.jenkinsci.plugins.DependencyCheck.aggregator.FindingsAggregator;
import org.jenkinsci.plugins.DependencyCheck.model.Finding;
import org.jenkinsci.plugins.DependencyCheck.model.ReportParser;
import org.jenkinsci.plugins.DependencyCheck.model.ReportParserException;
import org.jenkinsci.plugins.DependencyCheck.model.RiskGate;
import org.jenkinsci.plugins.DependencyCheck.model.SeverityDistribution;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyCheckPublisher
extends AbstractThresholdPublisher
implements SimpleBuildStep {
    private static final long serialVersionUID = -3849031519263613214L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyCheckPublisher.class);
    private static final String DEFAULT_PATTERN = "**/dependency-check-report.xml";
    private String pattern;
    private boolean stopBuild = false;
    private boolean skipNoReportFiles = false;

    @DataBoundConstructor
    public DependencyCheckPublisher() {
    }

    public String getPattern() {
        return this.pattern;
    }

    @DataBoundSetter
    public void setPattern(String pattern) {
        this.pattern = Util.fixEmptyAndTrim((String)pattern);
    }

    @DataBoundSetter
    public void setStopBuild(boolean stopBuild) {
        this.stopBuild = stopBuild;
    }

    public boolean isStopBuild() {
        return this.stopBuild;
    }

    public boolean isSkipNoReportFiles() {
        return this.skipNoReportFiles;
    }

    @DataBoundSetter
    public void setSkipNoReportFiles(boolean skipNoReportFiles) {
        this.skipNoReportFiles = skipNoReportFiles;
    }

    public void perform(@NonNull Run<?, ?> build, @NonNull FilePath filePath, @NonNull EnvVars env, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        Result result = this.process(build, filePath, launcher, listener);
        if (result.isWorseThan(Result.SUCCESS)) {
            listener.getLogger().println(Messages.Publisher_Threshold_Exceed());
            build.setResult(result);
        }
        if (Result.FAILURE == result && this.stopBuild) {
            throw new AbortException(Messages.Publisher_Threshold_Exceed());
        }
    }

    @Restricted(value={NoExternalUse.class})
    public Result process(@NonNull Run<?, ?> build, @NonNull FilePath filePath, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        logger.println(Messages.Publisher_CollectingArtifact());
        if (this.pattern == null) {
            this.pattern = DEFAULT_PATTERN;
        }
        Result result = Result.SUCCESS;
        FindingsAggregator findingsAggregator = new FindingsAggregator(build.getNumber());
        Object[] odcReportFiles = filePath.list(this.pattern);
        if (ArrayUtils.isEmpty((Object[])odcReportFiles)) {
            logger.println(Messages.Publisher_NoArtifactsFound());
            ResultAction projectAction = new ResultAction(build, findingsAggregator.getAggregatedFindings(), findingsAggregator.getSeverityDistribution());
            build.addAction((Action)projectAction);
            if (this.skipNoReportFiles) {
                return result;
            }
            return Result.UNSTABLE;
        }
        for (Object odcReportFile : odcReportFiles) {
            try {
                logger.println(Messages.Publisher_ParsingFile() + " " + odcReportFile.getRemote());
                List<Finding> findings = ReportParser.parse(odcReportFile.read());
                findingsAggregator.addFindings(findings);
            }
            catch (InvocationTargetException | ReportParserException e) {
                String errorMessage = Messages.Publisher_NotParsable(odcReportFile.getRemote());
                listener.error(errorMessage);
                LOGGER.error(errorMessage, (Throwable)e);
            }
        }
        SeverityDistribution currentDistribution = findingsAggregator.getSeverityDistribution();
        List<Finding> findings = findingsAggregator.getAggregatedFindings();
        ResultAction projectAction = new ResultAction(build, findings, currentDistribution);
        build.addAction((Action)projectAction);
        RiskGate riskGate = new RiskGate(this.getThresholds());
        SeverityDistribution previousDistribution = this.getPreviousSeverityDistribution(build, currentDistribution);
        Result reportResult = riskGate.evaluate(previousDistribution, currentDistribution);
        if (reportResult.isWorseThan(result)) {
            result = reportResult;
        }
        return result;
    }

    private SeverityDistribution getPreviousSeverityDistribution(Run<?, ?> build, SeverityDistribution defaultDistribution) {
        ResultAction previousResults;
        Run previousBuild = build.getPreviousBuild();
        if (previousBuild != null && (previousResults = (ResultAction)previousBuild.getAction(ResultAction.class)) != null) {
            return previousResults.getSeverityDistribution();
        }
        return defaultDistribution;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(DependencyCheckPublisher.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.Publisher_Name();
        }
    }
}

