/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.DependencyCheck.model;

import java.io.Serializable;
import java.util.Objects;
import org.jenkinsci.plugins.DependencyCheck.model.Dependency;
import org.jenkinsci.plugins.DependencyCheck.model.Severity;
import org.jenkinsci.plugins.DependencyCheck.model.Vulnerability;

public class Finding
implements Serializable {
    private static final long serialVersionUID = 2916981097517354202L;
    private int count;
    private final Dependency dependency;
    private final Vulnerability vulnerability;

    public Finding(Dependency dependency, Vulnerability vulnerability) {
        this.dependency = dependency;
        this.vulnerability = vulnerability;
        this.count = 1;
    }

    public Dependency getDependency() {
        return this.dependency;
    }

    public Vulnerability getVulnerability() {
        return this.vulnerability;
    }

    public Severity getNormalizedSeverity() {
        return Severity.normalize(this.vulnerability.getSeverity());
    }

    public void increaseCount() {
        ++this.count;
    }

    public int getCount() {
        return this.count;
    }

    public int hashCode() {
        return Objects.hash(this.dependency, this.vulnerability);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Finding other = (Finding)obj;
        return Objects.equals(this.dependency, other.dependency) && Objects.equals(this.vulnerability, other.vulnerability);
    }
}

