/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.DependencyCheck.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jenkinsci.plugins.DependencyCheck.model.CvssV2;
import org.jenkinsci.plugins.DependencyCheck.model.CvssV3;
import org.jenkinsci.plugins.DependencyCheck.model.Reference;

public class Vulnerability
implements Serializable {
    private static final long serialVersionUID = 2146048369342617342L;
    private Source source = null;
    private String name;
    private String description;
    private String severity;
    private CvssV2 cvssV2;
    private CvssV3 cvssV3;
    private List<String> cwes = new ArrayList<String>();
    private List<Reference> references = new ArrayList<Reference>();

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSeverity() {
        return this.severity;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public CvssV2 getCvssV2() {
        return this.cvssV2;
    }

    public void setCvssV2(CvssV2 cvssV2) {
        this.cvssV2 = cvssV2;
    }

    public CvssV3 getCvssV3() {
        return this.cvssV3;
    }

    public void setCvssV3(CvssV3 cvssV3) {
        this.cvssV3 = cvssV3;
    }

    public List<String> getCwes() {
        return this.cwes;
    }

    public void setCwes(List<String> cwes) {
        this.cwes = cwes;
    }

    public void addCwe(String cwe) {
        this.cwes.add(cwe);
    }

    public List<Reference> getReferences() {
        return this.references;
    }

    public void setReferences(List<Reference> references) {
        this.references = references;
    }

    public void addReference(Reference reference) {
        this.references.add(reference);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.severity, this.source});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vulnerability other = (Vulnerability)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.severity, other.severity) && this.source == other.source;
    }

    public String toString() {
        return this.name + " " + String.valueOf((Object)this.source);
    }

    public static enum Source {
        NVD,
        NPM,
        RETIREJS,
        OSSINDEX,
        BUNDLEAUDIT;

    }
}

