/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.DependencyCheck;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.tools.InstallSourceProperty;
import hudson.triggers.SCMTrigger;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.QuotedStringTokenizer;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.DependencyCheck.DependencyCheckUtil;
import org.jenkinsci.plugins.DependencyCheck.Messages;
import org.jenkinsci.plugins.DependencyCheck.tools.DependencyCheckInstallation;
import org.jenkinsci.plugins.DependencyCheck.tools.DependencyCheckInstaller;
import org.jenkinsci.plugins.DependencyCheck.tools.Version;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;
import org.springframework.security.core.Authentication;

public class DependencyCheckToolBuilder
extends Builder
implements SimpleBuildStep,
Serializable {
    private static final long serialVersionUID = 4267818809512542424L;
    private final String odcInstallation;
    private String additionalArguments;
    private String nvdCredentialsId;
    private boolean skipOnScmChange;
    private boolean skipOnUpstreamChange;
    private boolean stopBuild = false;
    private boolean debug = false;

    @DataBoundConstructor
    public DependencyCheckToolBuilder(String odcInstallation) {
        this.odcInstallation = Util.fixEmptyAndTrim((String)odcInstallation);
    }

    public String getOdcInstallation() {
        return this.odcInstallation;
    }

    public String getAdditionalArguments() {
        return this.additionalArguments;
    }

    @DataBoundSetter
    public void setAdditionalArguments(String additionalArguments) {
        this.additionalArguments = additionalArguments;
    }

    public boolean isSkipOnScmChange() {
        return this.skipOnScmChange;
    }

    @DataBoundSetter
    public void setSkipOnScmChange(boolean skipOnScmChange) {
        this.skipOnScmChange = skipOnScmChange;
    }

    public boolean isSkipOnUpstreamChange() {
        return this.skipOnUpstreamChange;
    }

    @DataBoundSetter
    public void setSkipOnUpstreamChange(boolean skipOnUpstreamChange) {
        this.skipOnUpstreamChange = skipOnUpstreamChange;
    }

    @DataBoundSetter
    public void setStopBuild(boolean stopBuild) {
        this.stopBuild = stopBuild;
    }

    public boolean isStopBuild() {
        return this.stopBuild;
    }

    public void perform(@NonNull Run<?, ?> build, @NonNull FilePath workspace, @NonNull EnvVars env, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        Node node;
        if (this.isSkip(build, listener)) {
            return;
        }
        DependencyCheckInstallation ni = this.getDependencyCheck();
        if (ni == null) {
            if (this.odcInstallation != null) {
                throw new AbortException(Messages.Builder_noInstallationFound(this.odcInstallation));
            }
            throw new AbortException(Messages.Builder_InstallationNotSpecified());
        }
        Computer computer = workspace.toComputer();
        Node node2 = node = computer != null ? computer.getNode() : null;
        if (node == null) {
            throw new AbortException(Messages.Builder_nodeOffline());
        }
        ni = ni.forNode(node, listener);
        String odcScript = (ni = ni.forEnvironment(env)).getExecutable(launcher);
        if (odcScript == null) {
            throw new AbortException(Messages.Builder_noExecutableFound(ni.getHome()));
        }
        ArgumentListBuilder cliArguments = this.buildArgumentList(odcScript, build, workspace, env, listener);
        int exitCode = launcher.launch().cmds(cliArguments).envs((Map)env).stdout((OutputStream)listener.getLogger()).quiet(!this.isDebug()).pwd(workspace).join();
        boolean success = this.isSuccess(exitCode);
        if (!success) {
            build.setResult(Result.FAILURE);
            if (this.stopBuild) {
                throw new AbortException(Messages.Publisher_FailBuild());
            }
            listener.error("Mark build as failed because of exit code " + exitCode);
        }
    }

    private boolean isSuccess(int exitCode) {
        Version v;
        DependencyCheckInstaller ui;
        InstallSourceProperty installSourceProperty = (InstallSourceProperty)this.getDependencyCheck().getProperties().get(InstallSourceProperty.class);
        if (installSourceProperty != null && (ui = (DependencyCheckInstaller)installSourceProperty.installers.get(DependencyCheckInstaller.class)) != null && (v = Version.parseVersion(ui.id)).getMajor() < 8) {
            return exitCode == 0;
        }
        return exitCode == 0 || exitCode == 14 || exitCode == 15;
    }

    private DependencyCheckInstallation getDependencyCheck() {
        return DependencyCheckUtil.getDependencyCheck(this.odcInstallation);
    }

    @NonNull
    protected ArgumentListBuilder buildArgumentList(@NonNull String odcScript, @NonNull Run<?, ?> build, @NonNull FilePath workspace, @NonNull EnvVars env, @NonNull TaskListener listener) throws AbortException {
        ArgumentListBuilder cliArguments = new ArgumentListBuilder(new String[]{odcScript});
        if (!StringUtils.contains((CharSequence)this.additionalArguments, (CharSequence)"--project")) {
            cliArguments.add(new String[]{"--project", build.getFullDisplayName()});
        } else if (this.debug) {
            listener.getLogger().println("Skip automatic project configuration because user already provides a --project parameter");
        }
        if (!StringUtils.containsAny((CharSequence)this.additionalArguments, (CharSequence[])new CharSequence[]{"--scan", "-s "})) {
            cliArguments.add(new String[]{"--scan", workspace.getRemote()});
        } else if (this.debug) {
            listener.getLogger().println("Skip automatic scan configuration because user already provides a --scan parameter");
        }
        if (!StringUtils.containsAny((CharSequence)this.additionalArguments, (CharSequence[])new CharSequence[]{"--format", "-f "})) {
            cliArguments.add(new String[]{"--format", "XML"});
        } else if (this.debug) {
            listener.getLogger().println("Skip automatic format configuration because user already provides a --format parameter");
        }
        this.configureProxy(cliArguments, env, listener);
        if (Util.fixEmptyAndTrim((String)this.additionalArguments) != null) {
            for (String addArg : QuotedStringTokenizer.tokenize((String)this.additionalArguments)) {
                if (Util.fixEmptyAndTrim((String)addArg) == null) continue;
                cliArguments.add(Util.replaceMacro((String)addArg, (Map)env));
            }
        }
        if (this.nvdCredentialsId != null) {
            StringCredentials c = (StringCredentials)CredentialsProvider.findCredentialById((String)this.nvdCredentialsId, StringCredentials.class, build);
            if (c == null) {
                throw new AbortException(Messages.Builder_DescriptorImpl_invalidCredentialsId());
            }
            cliArguments.add("--nvdApiKey").addMasked(c.getSecret());
        }
        return cliArguments;
    }

    private void configureProxy(@NonNull ArgumentListBuilder cliArguments, @NonNull EnvVars env, @NonNull TaskListener listener) {
        block13: {
            try {
                ProxyConfiguration proxyCfg = ProxyConfiguration.load();
                if (proxyCfg == null) break block13;
                if (!StringUtils.containsAny((CharSequence)this.additionalArguments, (CharSequence)"--proxyserver")) {
                    StringBuilder envVar = new StringBuilder();
                    String protocol = "https";
                    if (StringUtils.isNotBlank((CharSequence)proxyCfg.getName())) {
                        cliArguments.add(new String[]{"--proxyserver", proxyCfg.getName()});
                        try {
                            if (StringUtils.equalsIgnoreCase((CharSequence)protocol, (CharSequence)new URL(proxyCfg.getName()).getProtocol())) {
                                protocol = "http";
                            }
                        }
                        catch (MalformedURLException e) {
                            listener.error("Malformed proxy URL %s, default protocol set to %s. Cause: %s", new Object[]{proxyCfg.getName(), protocol, e.getMessage()});
                        }
                        envVar.append(" -D").append(protocol).append(".proxyHost=").append(proxyCfg.getName());
                    }
                    if (proxyCfg.getPort() > 0) {
                        cliArguments.add(new String[]{"--proxyport", String.valueOf(proxyCfg.getPort())});
                        envVar.append(" -D").append(protocol).append(".proxyPort=").append(proxyCfg.getPort());
                    }
                    if (StringUtils.isNotBlank((CharSequence)proxyCfg.getUserName())) {
                        cliArguments.add(new String[]{"--proxyuser", proxyCfg.getUserName()});
                        envVar.append(" -D").append(protocol).append(".proxyUser=").append(proxyCfg.getUserName());
                    }
                    if (proxyCfg.getSecretPassword() != null) {
                        cliArguments.add("--proxypass").addMasked(proxyCfg.getSecretPassword());
                        envVar.append(" -D").append(protocol).append(".proxyPassword=").append(Secret.toString((Secret)proxyCfg.getSecretPassword()));
                    }
                    if (StringUtils.isNotBlank((CharSequence)proxyCfg.getNoProxyHost())) {
                        String nonProxyHosts = proxyCfg.getNoProxyHost().replace("\n", ",");
                        cliArguments.add(new String[]{"--nonProxyHosts", nonProxyHosts});
                        envVar.append(" -Dhttp.nonProxyHosts=").append(nonProxyHosts);
                    }
                    if (!envVar.isEmpty()) {
                        env.override("JAVA_TOOL_OPTIONS+PROXY", StringUtils.trimToEmpty((String)envVar.toString()));
                    }
                    break block13;
                }
                if (this.debug) {
                    listener.getLogger().println("Skip automatic proxy configuration because user already provides a --proxyserver parameter");
                }
            }
            catch (IOException e) {
                listener.error("Error reading Proxy configuration. Cause: " + e.getMessage());
            }
        }
    }

    private boolean isSkip(Run<?, ?> build, TaskListener listener) {
        boolean skip = false;
        try {
            skip = Boolean.parseBoolean((String)build.getEnvironment(listener).get((Object)"OWASP_DC_SKIP"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        List causes = build.getCauses();
        for (Cause cause : causes) {
            if (this.skipOnScmChange && cause instanceof SCMTrigger.SCMTriggerCause) {
                skip = true;
            }
            if (!this.skipOnUpstreamChange || !(cause instanceof Cause.UpstreamCause)) continue;
            skip = true;
        }
        if (skip) {
            listener.getLogger().println(Messages.Builder_Skip());
        }
        return skip;
    }

    public String getNvdCredentialsId() {
        return this.nvdCredentialsId;
    }

    @DataBoundSetter
    public void setNvdCredentialsId(String nvdCredentialsId) {
        this.nvdCredentialsId = Util.fixEmpty((String)nvdCredentialsId);
    }

    public boolean isDebug() {
        return this.debug;
    }

    @DataBoundSetter
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Extension
    @Symbol(value={"dependencyCheck", "dependencycheck"})
    public static class DependencyCheckToolBuilderDescriptor
    extends BuildStepDescriptor<Builder> {
        private DependencyCheckInstallation[] installations = new DependencyCheckInstallation[0];

        public DependencyCheckInstallation[] loadInstalltions() {
            this.load();
            return this.installations;
        }

        public void purge() {
            XmlFile globalConfig = this.getConfigFile();
            FileUtils.deleteQuietly((File)globalConfig.getFile());
        }

        @POST
        public FormValidation doCheckdoNvdCredentialsId(@AncestorInPath @CheckForNull Item projectOrFolder, @QueryParameter String nvdCredentialsId) {
            CredentialsMatcher matcher;
            if (projectOrFolder == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER) || projectOrFolder != null && !projectOrFolder.hasPermission(Item.EXTENDED_READ) && !projectOrFolder.hasPermission(CredentialsProvider.USE_ITEM)) {
                return FormValidation.ok();
            }
            if (StringUtils.isBlank((CharSequence)nvdCredentialsId)) {
                return FormValidation.warning((String)Messages.Builder_DescriptorImpl_emptyCredentialsId());
            }
            Authentication authentication = this.getAuthentication((AccessControlled)projectOrFolder);
            if (CredentialsProvider.listCredentialsInItem(StringCredentials.class, (Item)projectOrFolder, (Authentication)authentication, null, (CredentialsMatcher)(matcher = CredentialsMatchers.withId((String)nvdCredentialsId))).isEmpty()) {
                return FormValidation.error((String)Messages.Builder_DescriptorImpl_invalidCredentialsId());
            }
            return FormValidation.ok();
        }

        @POST
        public ListBoxModel doFillNvdCredentialsIdItems(@AncestorInPath @CheckForNull ItemGroup<?> context, @AncestorInPath @CheckForNull Item projectOrFolder, @QueryParameter String nvdCredentialsId) {
            Jenkins contextToCheck;
            Permission permToCheck = projectOrFolder == null ? Jenkins.ADMINISTER : Item.CONFIGURE;
            Object object = contextToCheck = projectOrFolder == null ? Jenkins.get() : projectOrFolder;
            if (!contextToCheck.hasPermission(permToCheck)) {
                return new StandardUsernameListBoxModel().includeCurrentValue(StringUtils.trimToEmpty((String)nvdCredentialsId));
            }
            Authentication authentication = this.getAuthentication((AccessControlled)projectOrFolder);
            CredentialsMatcher matcher = CredentialsMatchers.instanceOf(StringCredentials.class);
            Class<StringCredentials> type = StringCredentials.class;
            ItemGroup<?> credentialsContext = context == null ? Jenkins.get() : context;
            return new StandardListBoxModel().includeMatchingAs(authentication, credentialsContext, type, Collections.emptyList(), matcher).includeEmptyValue();
        }

        @NonNull
        protected Authentication getAuthentication(AccessControlled item) {
            return item instanceof Queue.Task ? Tasks.getAuthenticationOf2((Queue.Task)((Queue.Task)item)) : ACL.SYSTEM2;
        }

        @NonNull
        public String getDisplayName() {
            return Messages.Builder_Name();
        }

        public DependencyCheckInstallation[] getInstallations() {
            return DependencyCheckUtil.getInstallations();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

