/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.database.steps;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.TaskListener;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.database.steps.DatabaseContext;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class SQLStep
extends Step {
    @Extension(optional=true)
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private static final Logger LOG = Logger.getLogger(SQLStep.class.getName());
    private String sql;
    private String connection;
    private List<Object> parameters;

    @DataBoundConstructor
    public SQLStep(String sql) {
        this.sql = Util.fixEmptyAndTrim((String)sql);
    }

    public String getSql() {
        return this.sql;
    }

    public String getConnection() {
        return this.connection;
    }

    @DataBoundSetter
    public void setConnection(@CheckForNull String connection) {
        this.connection = Util.fixEmptyAndTrim((String)connection);
    }

    public List<Object> getParameters() {
        return this.parameters;
    }

    @DataBoundSetter
    public void setParameters(List<Object> parameters) {
        this.parameters = parameters;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public StepDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public static class Execution
    extends SynchronousNonBlockingStepExecution<List<Map<String, Object>>> {
        private static final long serialVersionUID = 1L;
        private final transient SQLStep step;

        protected Execution(SQLStep step, @NonNull StepContext context) {
            super(context);
            this.step = step;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected List<Map<String, Object>> run() throws Exception {
            PreparedStatement preparedStatement;
            ArrayList<Map<String, Object>> rt;
            block17: {
                ResultSet set;
                rt = new ArrayList<Map<String, Object>>();
                LOG.log(Level.FINE, "Running SQL {0} with parameters {1} on connection {2}", new Object[]{this.step.sql, this.step.parameters, this.step.connection});
                Connection connection = ((DatabaseContext)this.getContext().get(DatabaseContext.class)).getConnection(this.step.connection);
                preparedStatement = connection.prepareStatement(this.step.sql);
                try {
                    if (this.step.parameters != null && !this.step.parameters.isEmpty()) {
                        for (int i = 0; i < this.step.parameters.size(); ++i) {
                            preparedStatement.setObject(i + 1, this.step.parameters.get(i));
                        }
                    }
                    if (!preparedStatement.execute()) break block17;
                    set = preparedStatement.getResultSet();
                    try {}
                    catch (Throwable throwable) {
                        if (set == null) throw throwable;
                        try {
                            set.close();
                            throw throwable;
                        }
                        catch (SQLException e) {
                            ((TaskListener)this.getContext().get(TaskListener.class)).error("Error closing resultset %s", new Object[]{e});
                        }
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    if (preparedStatement == null) throw throwable;
                    try {
                        preparedStatement.close();
                        throw throwable;
                    }
                    catch (SQLException e) {
                        ((TaskListener)this.getContext().get(TaskListener.class)).error("Error closing statement %s", new Object[]{e});
                    }
                    throw throwable;
                }
                while (set.next()) {
                    TreeMap<String, Object> row = new TreeMap<String, Object>();
                    for (int i = 1; i <= set.getMetaData().getColumnCount(); ++i) {
                        row.put(set.getMetaData().getColumnName(i), set.getObject(i));
                    }
                    rt.add(row);
                }
                LOG.log(Level.FINE, "Got {0} rows", rt.size());
                if (set != null) {
                    try {
                        set.close();
                    }
                    catch (SQLException e) {
                        ((TaskListener)this.getContext().get(TaskListener.class)).error("Error closing resultset %s", new Object[]{e});
                    }
                }
            }
            if (preparedStatement == null) return rt;
            try {
                preparedStatement.close();
                return rt;
            }
            catch (SQLException e) {
                ((TaskListener)this.getContext().get(TaskListener.class)).error("Error closing statement %s", new Object[]{e});
                return rt;
            }
        }
    }

    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            HashSet context = new HashSet();
            Collections.addAll(context, DatabaseContext.class, TaskListener.class);
            return Collections.unmodifiableSet(context);
        }

        public String getFunctionName() {
            return "sql";
        }

        @NonNull
        public String getDisplayName() {
            return "Run SQL";
        }
    }
}

