/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.database.steps;

import java.io.Serializable;
import java.sql.Connection;
import java.text.MessageFormat;
import org.jenkinsci.plugins.database.steps.FailedToGetDatabaseException;

public class DatabaseContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final DatabaseContext parent;
    private final transient Connection connection;
    private final String id;

    public DatabaseContext(DatabaseContext parent, Connection connection, String id) {
        this.parent = parent;
        this.connection = connection;
        this.id = id;
    }

    public Connection getConnection(String id) throws FailedToGetDatabaseException {
        if (id == null || id.equals(this.id)) {
            return this.connection;
        }
        if (this.parent != null) {
            return this.parent.getConnection(id);
        }
        throw new FailedToGetDatabaseException(MessageFormat.format("Failed to get connection to database {0}", id));
    }
}

