/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.database.steps;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.util.ListBoxModel;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.database.Database;
import org.jenkinsci.plugins.database.GlobalDatabaseConfiguration;
import org.jenkinsci.plugins.database.PerItemDatabase;
import org.jenkinsci.plugins.database.PerItemDatabaseConfiguration;
import org.jenkinsci.plugins.database.steps.DatabaseContext;
import org.jenkinsci.plugins.database.steps.DatabaseType;
import org.jenkinsci.plugins.database.steps.FailedToGetDatabaseException;
import org.jenkinsci.plugins.workflow.steps.BodyExecution;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DatabaseConnectionStep
extends Step {
    @Extension(optional=true)
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private static final Logger LOG = Logger.getLogger(DatabaseConnectionStep.class.getName());
    private DatabaseType type;
    private String id;

    @DataBoundConstructor
    public DatabaseConnectionStep() {
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public DatabaseType getType() {
        return this.type;
    }

    @DataBoundSetter
    public void setType(DatabaseType type) {
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    @DataBoundSetter
    public void setId(@CheckForNull String id) {
        this.id = Util.fixEmptyAndTrim((String)id);
    }

    public StepDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public static class Execution
    extends StepExecution {
        private static final long serialVersionUID = 1L;
        private final transient DatabaseConnectionStep step;
        private transient Connection connection;
        private transient BodyExecution execution;

        public Execution(DatabaseConnectionStep step, @NonNull StepContext context) {
            super(context);
            this.step = step;
        }

        public void onResume() {
            throw new RuntimeException("Database operations can't be resumed");
        }

        public boolean start() throws Exception {
            this.fetchDatabase();
            try {
                DatabaseContext dbContext = new DatabaseContext((DatabaseContext)this.getContext().get(DatabaseContext.class), this.connection, this.step.id);
                this.execution = this.getContext().newBodyInvoker().withContext((Object)dbContext).withCallback((BodyExecutionCallback)new BodyExecutionCallback.TailCall(){

                    protected void finished(StepContext context) throws Exception {
                        this.closeConnection();
                    }
                }).start();
                return false;
            }
            catch (Exception e) {
                this.closeConnection();
                this.getContext().onFailure((Throwable)e);
                return true;
            }
        }

        private void fetchDatabase() throws Exception {
            try {
                LOG.log(Level.FINE, "Fetching database connection of type {0}", (Object)this.step.type);
                switch (this.step.type) {
                    default: {
                        GlobalDatabaseConfiguration globalDatabaseConfiguration = (GlobalDatabaseConfiguration)((Object)ExtensionList.lookupSingleton(GlobalDatabaseConfiguration.class));
                        Database database = globalDatabaseConfiguration.getDatabase();
                        if (database == null) break;
                        this.connection = database.getDataSource().getConnection();
                        break;
                    }
                    case PERITEM: {
                        if (((Run)this.getContext().get(Run.class)).getParent() instanceof TopLevelItem) {
                            PerItemDatabaseConfiguration perItemDatabaseConfiguration = (PerItemDatabaseConfiguration)((Object)ExtensionList.lookupSingleton(PerItemDatabaseConfiguration.class));
                            PerItemDatabase perItemDatabase = perItemDatabaseConfiguration.getDatabase();
                            if (perItemDatabase == null) break;
                            this.connection = perItemDatabase.getDataSource((TopLevelItem)((Run)this.getContext().get(Run.class)).getParent()).getConnection();
                            break;
                        }
                        throw new FailedToGetDatabaseException("Failed to get per item database build.getParent is not instance of TopLevelItem? " + String.valueOf(((Run)this.getContext().get(Run.class)).getParent().getClass()));
                    }
                }
                LOG.log(Level.FINE, "Got database connection");
            }
            catch (SQLException e) {
                throw new FailedToGetDatabaseException("Failed to get database connection", e);
            }
        }

        private void closeConnection() throws Exception {
            if (this.connection != null) {
                try {
                    LOG.log(Level.FINE, "Closing database connection");
                    this.connection.close();
                    this.connection = null;
                }
                catch (SQLException e) {
                    ((TaskListener)this.getContext().get(TaskListener.class)).error("Failed to close connection %s", new Object[]{e});
                }
            }
        }

        public void stop(@NonNull Throwable cause) throws Exception {
            LOG.log(Level.FINE, "Recived stop request", cause);
            try {
                if (this.execution != null) {
                    this.execution.cancel(cause);
                    this.execution = null;
                }
            }
            finally {
                this.closeConnection();
            }
        }
    }

    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            HashSet context = new HashSet();
            Collections.addAll(context, Run.class, TaskListener.class);
            return Collections.unmodifiableSet(context);
        }

        public String getFunctionName() {
            return "getDatabaseConnection";
        }

        @NonNull
        public String getDisplayName() {
            return "Get Database Connection";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public ListBoxModel doFillTypeItems() {
            ListBoxModel items = new ListBoxModel();
            for (DatabaseType dataType : DatabaseType.values()) {
                items.add(dataType.getDisplayName(), dataType.name());
            }
            return items;
        }
    }
}

