/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.database;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.FormValidation;
import hudson.util.Secret;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.jdbc.datasource.JdbcTelemetry;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.sql.SQLException;
import javax.sql.DataSource;
import jenkins.model.Jenkins;
import org.apache.tools.ant.AntClassLoader;
import org.jenkinsci.plugins.database.BasicDataSource2;
import org.jenkinsci.plugins.database.Database;
import org.jenkinsci.plugins.database.DatabaseDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class GenericDatabase
extends Database {
    public final String driver;
    public final String username;
    public final Secret password;
    public final String url;
    private Integer initialSize = DescriptorImpl.defaultInitialSize;
    private Integer maxTotal = DescriptorImpl.defaultMaxTotal;
    private Integer maxIdle = DescriptorImpl.defaultMaxIdle;
    private Integer minIdle = DescriptorImpl.defaultMinIdle;
    private transient DataSource dataSource;

    @DataBoundConstructor
    public GenericDatabase(String url, String driver, String username, Secret password) {
        this.url = url;
        this.driver = driver;
        this.username = username;
        this.password = password;
    }

    @NonNull
    public Integer getInitialSize() {
        return this.initialSize;
    }

    @DataBoundSetter
    public void setInitialSize(Integer initialSize) {
        this.initialSize = initialSize == null ? DescriptorImpl.defaultInitialSize : initialSize;
    }

    @NonNull
    public Integer getMaxTotal() {
        return this.maxTotal;
    }

    @DataBoundSetter
    public void setMaxTotal(Integer maxTotal) {
        this.maxTotal = maxTotal == null ? DescriptorImpl.defaultMaxTotal : maxTotal;
    }

    @NonNull
    public Integer getMaxIdle() {
        return this.maxIdle;
    }

    @DataBoundSetter
    public void setMaxIdle(Integer maxIdle) {
        this.maxIdle = maxIdle == null ? DescriptorImpl.defaultMaxIdle : maxIdle;
    }

    @NonNull
    public Integer getMinIdle() {
        return this.minIdle;
    }

    @DataBoundSetter
    public void setMinIdle(Integer minIdle) {
        this.minIdle = minIdle == null ? DescriptorImpl.defaultMinIdle : minIdle;
    }

    @Override
    public synchronized DataSource getDataSource() throws SQLException {
        if (this.dataSource == null) {
            BasicDataSource2 source = new BasicDataSource2();
            source.setDriverClassLoader(this.getDescriptor().getClassLoader());
            source.setDriverClassName(this.driver);
            source.setUrl(this.url);
            source.setUsername(this.username);
            source.setPassword(Secret.toString((Secret)this.password));
            source.setInitialSize(this.initialSize);
            source.setMaxTotal(this.maxTotal);
            source.setMaxIdle(this.maxIdle);
            source.setMinIdle(this.minIdle);
            this.dataSource = this.isOTelJdbcInstrumentationEnabled() ? JdbcTelemetry.create((OpenTelemetry)GlobalOpenTelemetry.get()).wrap(source.createDataSource()) : source.createDataSource();
        }
        return this.dataSource;
    }

    @Override
    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension(ordinal=-1000.0)
    public static class DescriptorImpl
    extends DatabaseDescriptor {
        private transient AntClassLoader loader;
        public static final Integer defaultInitialSize = 0;
        public static final Integer defaultMaxTotal = 8;
        public static final Integer defaultMaxIdle = 8;
        public static final Integer defaultMinIdle = 0;

        public String getDisplayName() {
            return "Generic";
        }

        private synchronized ClassLoader getClassLoader() {
            if (this.loader == null) {
                this.loader = new AntClassLoader(HttpServletRequest.class.getClassLoader(), true);
                File[] files = new File(Jenkins.getInstance().getRootDir(), "jdbc-drivers").listFiles();
                if (files != null) {
                    for (File jar : files) {
                        if (!jar.getName().endsWith(".jar")) continue;
                        this.loader.addPathComponent(jar);
                    }
                }
            }
            return this.loader;
        }

        @POST
        public FormValidation doCheckDriver(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (value.length() == 0) {
                return FormValidation.ok();
            }
            try {
                this.getClassLoader().loadClass(value);
                return FormValidation.ok();
            }
            catch (ClassNotFoundException e) {
                return FormValidation.error((String)("No such class: " + value));
            }
        }

        @POST
        public FormValidation doValidate(@QueryParameter String driver, @QueryParameter String url, @QueryParameter String username, @QueryParameter Secret password) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            try {
                new GenericDatabase(url, driver, username, password).getDataSource();
                return FormValidation.ok((String)"OK");
            }
            catch (SQLException e) {
                return FormValidation.error((Throwable)e, (String)"Failed to connect");
            }
        }
    }
}

