/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.database.sqlite;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import javax.sql.DataSource;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.database.BasicDataSource2;
import org.jenkinsci.plugins.database.Database;
import org.jenkinsci.plugins.database.DatabaseDescriptor;
import org.jenkinsci.plugins.database.GlobalDatabaseConfiguration;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;
import org.sqlite.JDBC;

public class GlobalSQLiteDatabase
extends Database {
    private final File path;
    private transient DataSource source;
    private static final String DB_FILENAME = "db.db";

    @DataBoundConstructor
    public GlobalSQLiteDatabase(File path) {
        this.path = path;
    }

    public File getPath() {
        return this.path;
    }

    public synchronized DataSource getDataSource() throws SQLException {
        if (this.source == null) {
            BasicDataSource2 fac = new BasicDataSource2();
            fac.setDriverClass(JDBC.class);
            String path = this.path.toURI().toString();
            fac.setUrl("jdbc:sqlite:" + path + (path.endsWith("/") ? "" : "/") + DB_FILENAME);
            this.source = fac.createDataSource();
        }
        return this.source;
    }

    @Initializer(after=InitMilestone.PLUGINS_STARTED)
    public static void setDefaultGlobalDatabase() {
        GlobalDatabaseConfiguration gdc;
        Jenkins j = Jenkins.get();
        File globalDir = new File(j.getRootDir(), "global");
        if (!Files.isDirectory(globalDir.toPath(), new LinkOption[0])) {
            try {
                Files.createDirectory(globalDir.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if ((gdc = (GlobalDatabaseConfiguration)j.getExtensionList(GlobalConfiguration.class).get(GlobalDatabaseConfiguration.class)) != null && gdc.getDatabase() == null) {
            gdc.setDatabase((Database)new GlobalSQLiteDatabase(globalDir));
        }
    }

    @Extension
    public static class DescriptorImpl
    extends DatabaseDescriptor {
        @NonNull
        public String getDisplayName() {
            return "SQLite global database";
        }

        @POST
        public FormValidation doCheckPath(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (value.isEmpty()) {
                return FormValidation.ok();
            }
            if (new File(value, GlobalSQLiteDatabase.DB_FILENAME).exists()) {
                return FormValidation.ok((String)"This database already exists.");
            }
            if (new File(value).isFile()) {
                return FormValidation.error((String)"%s is a file; must be a directory.", (Object[])new Object[]{value});
            }
            return FormValidation.ok((String)"This database doesn't exist yet. It will be created.");
        }
    }
}

