/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.database.postgresql;

import hudson.Extension;
import hudson.Util;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.sql.DriverPropertyInfo;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.database.AbstractRemoteDatabase;
import org.jenkinsci.plugins.database.AbstractRemoteDatabaseDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;
import org.postgresql.Driver;

public class PostgreSQLDatabase
extends AbstractRemoteDatabase {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public PostgreSQLDatabase(String hostname, String database, String username, Secret password, String properties) {
        super(hostname, database, username, password, properties);
    }

    protected Class<Driver> getDriverClass() {
        return Driver.class;
    }

    protected String getJdbcUrl() {
        return "jdbc:postgresql://" + this.hostname + "/" + this.database;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractRemoteDatabaseDescriptor {
        public String getDisplayName() {
            return "PostgreSQL";
        }

        @POST
        public FormValidation doCheckProperties(@QueryParameter String properties) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            try {
                HashSet<String> validPropertyNames = new HashSet<String>();
                Properties props = Util.loadProperties((String)properties);
                for (DriverPropertyInfo p : new Driver().getPropertyInfo("jdbc:postgresql://localhost/dummy", props)) {
                    validPropertyNames.add(p.name);
                }
                for (Map.Entry entry : props.entrySet()) {
                    String key = entry.getKey().toString();
                    if (validPropertyNames.contains(key)) continue;
                    return FormValidation.error((String)("Unrecognized property: " + key));
                }
                return FormValidation.ok();
            }
            catch (Throwable e) {
                return FormValidation.warning((Throwable)e, (String)"Failed to validate the connection properties");
            }
        }
    }
}

