/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.database.h2;

import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.TopLevelItem;
import java.sql.SQLException;
import java.util.Map;
import java.util.WeakHashMap;
import javax.sql.DataSource;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import org.h2.Driver;
import org.jenkinsci.plugins.database.BasicDataSource2;
import org.jenkinsci.plugins.database.PerItemDatabase;
import org.jenkinsci.plugins.database.PerItemDatabaseConfiguration;
import org.jenkinsci.plugins.database.PerItemDatabaseDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;

public class PerItemH2Database
extends PerItemDatabase {
    private final boolean autoServer;
    private transient Map<TopLevelItem, DataSource> sources;

    @DataBoundConstructor
    public PerItemH2Database(boolean autoServer) {
        this.autoServer = autoServer;
    }

    public DataSource getDataSource(TopLevelItem item) throws SQLException {
        DataSource source;
        if (this.sources == null) {
            this.sources = new WeakHashMap<TopLevelItem, DataSource>();
        }
        if ((source = this.sources.get(item)) == null) {
            BasicDataSource2 fac = new BasicDataSource2();
            fac.setDriverClass(Driver.class);
            fac.setUrl(this.appendUrlParameters("jdbc:h2:" + String.valueOf(item.getRootDir().toURI()) + "data"));
            source = fac.createDataSource();
            this.sources.put(item, source);
        }
        return source;
    }

    private String appendUrlParameters(String url) {
        if (this.getAutoServer()) {
            url = (String)url + ";AUTO_SERVER=true";
        }
        return url;
    }

    public boolean getAutoServer() {
        return this.autoServer;
    }

    @Initializer(after=InitMilestone.PLUGINS_STARTED)
    public static void setDefaultPerItemDatabase() {
        Jenkins j = Jenkins.getInstance();
        PerItemDatabaseConfiguration pidbc = (PerItemDatabaseConfiguration)j.getExtensionList(GlobalConfiguration.class).get(PerItemDatabaseConfiguration.class);
        if (pidbc != null && pidbc.getDatabase() == null) {
            pidbc.setDatabase((PerItemDatabase)new PerItemH2Database(false));
        }
    }

    @Extension
    public static class DescriptorImpl
    extends PerItemDatabaseDescriptor {
        public String getDisplayName() {
            return "Embedded local database (H2)";
        }
    }
}

