/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.database.h2;

import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.util.FormValidation;
import java.io.File;
import java.sql.SQLException;
import javax.sql.DataSource;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import org.h2.Driver;
import org.jenkinsci.plugins.database.BasicDataSource2;
import org.jenkinsci.plugins.database.Database;
import org.jenkinsci.plugins.database.DatabaseDescriptor;
import org.jenkinsci.plugins.database.GlobalDatabaseConfiguration;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class LocalH2Database
extends Database {
    private final File path;
    private final boolean autoServer;
    private transient DataSource source;

    @DataBoundConstructor
    public LocalH2Database(File path, boolean autoServer) {
        this.path = path;
        this.autoServer = autoServer;
    }

    public File getPath() {
        return this.path;
    }

    public synchronized DataSource getDataSource() throws SQLException {
        if (this.source == null) {
            BasicDataSource2 fac = new BasicDataSource2();
            fac.setDriverClass(Driver.class);
            String pathU = this.path.toURI().toString();
            fac.setUrl(this.appendUrlParameters("jdbc:h2:" + pathU + (pathU.endsWith("/") ? "" : "/") + "data"));
            this.source = fac.createDataSource();
        }
        return this.source;
    }

    private String appendUrlParameters(String url) {
        if (this.getAutoServer()) {
            url = (String)url + ";AUTO_SERVER=true";
        }
        return url;
    }

    public boolean getAutoServer() {
        return this.autoServer;
    }

    @Initializer(after=InitMilestone.PLUGINS_STARTED)
    public static void setDefaultGlobalDatabase() {
        Jenkins j = Jenkins.getInstance();
        GlobalDatabaseConfiguration gdc = (GlobalDatabaseConfiguration)j.getExtensionList(GlobalConfiguration.class).get(GlobalDatabaseConfiguration.class);
        if (gdc != null && gdc.getDatabase() == null) {
            gdc.setDatabase((Database)new LocalH2Database(new File(j.getRootDir(), "global"), false));
        }
    }

    @Extension
    public static class DescriptorImpl
    extends DatabaseDescriptor {
        public String getDisplayName() {
            return "Embedded local database (H2)";
        }

        public FormValidation doCheckPath(@QueryParameter String value) {
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            if (value.length() == 0) {
                return FormValidation.ok();
            }
            if (new File(value, "data.h2.db").exists()) {
                return FormValidation.ok((String)"This database already exists.");
            }
            if (new File(value).isFile()) {
                return FormValidation.error((String)"%s is a file; must be a directory.", (Object[])new Object[]{value});
            }
            return FormValidation.ok((String)"This database doesn't exist yet. It will be created.");
        }
    }
}

