/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.view.dashboard.core;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.plugins.view.dashboard.DashboardPortlet;
import hudson.plugins.view.dashboard.Messages;
import hudson.util.FormValidation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import jenkins.util.SystemProperties;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class IframePortlet
extends DashboardPortlet {
    private String iframeSource;
    private String effectiveUrl;
    private final String divStyle;
    private static boolean DO_NOT_USE_SANDBOX = SystemProperties.getBoolean((String)(IframePortlet.class.getName() + ".doNotUseSandbox"));
    private static String SANDBOX_VALUE = SystemProperties.getString((String)(IframePortlet.class.getName() + ".sandboxAttributeValue"), (String)"");

    @DataBoundConstructor
    public IframePortlet(String name, String divStyle) {
        super(name);
        this.divStyle = divStyle;
    }

    public String getIframeSource() {
        return this.iframeSource;
    }

    public String getEffectiveUrl() {
        return this.effectiveUrl;
    }

    public String getDivStyle() {
        return this.divStyle;
    }

    @DataBoundSetter
    public void setIframeSource(String iframeSource) {
        this.iframeSource = iframeSource;
        this.overridePlaceholdersInUrl();
    }

    public boolean isIframeSourceValid() {
        return IframePortlet.getUrlError(this.iframeSource) == null;
    }

    public boolean isUseSandbox() {
        return !DO_NOT_USE_SANDBOX;
    }

    public String getSandboxValue() {
        return SANDBOX_VALUE;
    }

    private void overridePlaceholdersInUrl() {
        if (this.iframeSource != null) {
            if (this.getDashboard() != null) {
                this.effectiveUrl = this.iframeSource.replaceAll("\\$\\{viewName\\}", this.getDashboard().getViewName());
                this.effectiveUrl = this.effectiveUrl.replaceAll("\\$\\{jobsList\\}", this.jobsListAsString());
            } else {
                this.effectiveUrl = this.iframeSource;
            }
        } else {
            this.effectiveUrl = null;
        }
    }

    private String jobsListAsString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Job> jobs = this.getDashboard().getJobs().iterator();
        if (jobs.hasNext()) {
            sb.append(jobs.next().getName());
        }
        while (jobs.hasNext()) {
            sb.append(",");
            sb.append(jobs.next().getName());
        }
        return sb.toString();
    }

    @CheckForNull
    protected static final String getUrlError(String url) {
        if (url == null || url.isBlank()) {
            return Messages.Dashboard_UrlEmpty();
        }
        try {
            URI allowedUrl = new URI(url);
            String protocol = allowedUrl.getScheme();
            if (!allowedUrl.isAbsolute() || protocol.equals("http") || protocol.equals("https")) {
                return null;
            }
            return Messages.Dashboard_UrlHttp();
        }
        catch (URISyntaxException e) {
            return Messages.Dashboard_UrlInvalid(e.getMessage());
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<DashboardPortlet> {
        public String getDisplayName() {
            return Messages.Dashboard_IframePortlet();
        }

        public FormValidation doCheckIframeSource(@QueryParameter String value) {
            String error = IframePortlet.getUrlError(value);
            if (error != null) {
                return FormValidation.error((String)error);
            }
            return FormValidation.ok();
        }
    }
}

