// CHECKSTYLE:OFF

package hudson.plugins.view.dashboard;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code Dashboard.ImageUrlHttp}: {@code Image URL must be http or
     * https.}.
     * 
     * @return
     *     {@code Image URL must be http or https.}
     */
    public static String Dashboard_ImageUrlHttp() {
        return holder.format("Dashboard.ImageUrlHttp");
    }

    /**
     * Key {@code Dashboard.ImageUrlHttp}: {@code Image URL must be http or
     * https.}.
     * 
     * @return
     *     {@code Image URL must be http or https.}
     */
    public static Localizable _Dashboard_ImageUrlHttp() {
        return new Localizable(holder, "Dashboard.ImageUrlHttp");
    }

    /**
     * Key {@code Dashboard.TestStatisticsChart}: {@code Test Statistics
     * Chart}.
     * 
     * @return
     *     {@code Test Statistics Chart}
     */
    public static String Dashboard_TestStatisticsChart() {
        return holder.format("Dashboard.TestStatisticsChart");
    }

    /**
     * Key {@code Dashboard.TestStatisticsChart}: {@code Test Statistics
     * Chart}.
     * 
     * @return
     *     {@code Test Statistics Chart}
     */
    public static Localizable _Dashboard_TestStatisticsChart() {
        return new Localizable(holder, "Dashboard.TestStatisticsChart");
    }

    /**
     * Key {@code Dashboard.NoDataAvailable}: {@code No data available}.
     * 
     * @return
     *     {@code No data available}
     */
    public static String Dashboard_NoDataAvailable() {
        return holder.format("Dashboard.NoDataAvailable");
    }

    /**
     * Key {@code Dashboard.NoDataAvailable}: {@code No data available}.
     * 
     * @return
     *     {@code No data available}
     */
    public static Localizable _Dashboard_NoDataAvailable() {
        return new Localizable(holder, "Dashboard.NoDataAvailable");
    }

    /**
     * Key {@code Dashboard.ImageUrlEmpty}: {@code Image URL should not be
     * empty.}.
     * 
     * @return
     *     {@code Image URL should not be empty.}
     */
    public static String Dashboard_ImageUrlEmpty() {
        return holder.format("Dashboard.ImageUrlEmpty");
    }

    /**
     * Key {@code Dashboard.ImageUrlEmpty}: {@code Image URL should not be
     * empty.}.
     * 
     * @return
     *     {@code Image URL should not be empty.}
     */
    public static Localizable _Dashboard_ImageUrlEmpty() {
        return new Localizable(holder, "Dashboard.ImageUrlEmpty");
    }

    /**
     * Key {@code Dashboard.DisplayName}: {@code Dashboard}.
     * 
     * @return
     *     {@code Dashboard}
     */
    public static String Dashboard_DisplayName() {
        return holder.format("Dashboard.DisplayName");
    }

    /**
     * Key {@code Dashboard.DisplayName}: {@code Dashboard}.
     * 
     * @return
     *     {@code Dashboard}
     */
    public static Localizable _Dashboard_DisplayName() {
        return new Localizable(holder, "Dashboard.DisplayName");
    }

    /**
     * Key {@code Dashboard.UrlEmpty}: {@code URL should not be empty.}.
     * 
     * @return
     *     {@code URL should not be empty.}
     */
    public static String Dashboard_UrlEmpty() {
        return holder.format("Dashboard.UrlEmpty");
    }

    /**
     * Key {@code Dashboard.UrlEmpty}: {@code URL should not be empty.}.
     * 
     * @return
     *     {@code URL should not be empty.}
     */
    public static Localizable _Dashboard_UrlEmpty() {
        return new Localizable(holder, "Dashboard.UrlEmpty");
    }

    /**
     * Key {@code Dashboard.AllRecentBuildsFailed}: {@code All recent builds
     * failed}.
     * 
     * @return
     *     {@code All recent builds failed}
     */
    public static String Dashboard_AllRecentBuildsFailed() {
        return holder.format("Dashboard.AllRecentBuildsFailed");
    }

    /**
     * Key {@code Dashboard.AllRecentBuildsFailed}: {@code All recent builds
     * failed}.
     * 
     * @return
     *     {@code All recent builds failed}
     */
    public static Localizable _Dashboard_AllRecentBuildsFailed() {
        return new Localizable(holder, "Dashboard.AllRecentBuildsFailed");
    }

    /**
     * Key {@code Dashboard.Success}: {@code success}.
     * 
     * @return
     *     {@code success}
     */
    public static String Dashboard_Success() {
        return holder.format("Dashboard.Success");
    }

    /**
     * Key {@code Dashboard.Success}: {@code success}.
     * 
     * @return
     *     {@code success}
     */
    public static Localizable _Dashboard_Success() {
        return new Localizable(holder, "Dashboard.Success");
    }

    /**
     * Key {@code Dashboard.Failed}: {@code failed}.
     * 
     * @return
     *     {@code failed}
     */
    public static String Dashboard_Failed() {
        return holder.format("Dashboard.Failed");
    }

    /**
     * Key {@code Dashboard.Failed}: {@code failed}.
     * 
     * @return
     *     {@code failed}
     */
    public static Localizable _Dashboard_Failed() {
        return new Localizable(holder, "Dashboard.Failed");
    }

    /**
     * Key {@code Dashboard.IframePortlet}: {@code Iframe Portlet}.
     * 
     * @return
     *     {@code Iframe Portlet}
     */
    public static String Dashboard_IframePortlet() {
        return holder.format("Dashboard.IframePortlet");
    }

    /**
     * Key {@code Dashboard.IframePortlet}: {@code Iframe Portlet}.
     * 
     * @return
     *     {@code Iframe Portlet}
     */
    public static Localizable _Dashboard_IframePortlet() {
        return new Localizable(holder, "Dashboard.IframePortlet");
    }

    /**
     * Key {@code Dashboard.Skipped}: {@code skipped}.
     * 
     * @return
     *     {@code skipped}
     */
    public static String Dashboard_Skipped() {
        return holder.format("Dashboard.Skipped");
    }

    /**
     * Key {@code Dashboard.Skipped}: {@code skipped}.
     * 
     * @return
     *     {@code skipped}
     */
    public static Localizable _Dashboard_Skipped() {
        return new Localizable(holder, "Dashboard.Skipped");
    }

    /**
     * Key {@code Dashboard.Image}: {@code Image}.
     * 
     * @return
     *     {@code Image}
     */
    public static String Dashboard_Image() {
        return holder.format("Dashboard.Image");
    }

    /**
     * Key {@code Dashboard.Image}: {@code Image}.
     * 
     * @return
     *     {@code Image}
     */
    public static Localizable _Dashboard_Image() {
        return new Localizable(holder, "Dashboard.Image");
    }

    /**
     * Key {@code Dashboard.TestTrendChart}: {@code Test Trend Chart}.
     * 
     * @return
     *     {@code Test Trend Chart}
     */
    public static String Dashboard_TestTrendChart() {
        return holder.format("Dashboard.TestTrendChart");
    }

    /**
     * Key {@code Dashboard.TestTrendChart}: {@code Test Trend Chart}.
     * 
     * @return
     *     {@code Test Trend Chart}
     */
    public static Localizable _Dashboard_TestTrendChart() {
        return new Localizable(holder, "Dashboard.TestTrendChart");
    }

    /**
     * Key {@code Dashboard.JenkinsJobsList}: {@code Jenkins jobs list}.
     * 
     * @return
     *     {@code Jenkins jobs list}
     */
    public static String Dashboard_JenkinsJobsList() {
        return holder.format("Dashboard.JenkinsJobsList");
    }

    /**
     * Key {@code Dashboard.JenkinsJobsList}: {@code Jenkins jobs list}.
     * 
     * @return
     *     {@code Jenkins jobs list}
     */
    public static Localizable _Dashboard_JenkinsJobsList() {
        return new Localizable(holder, "Dashboard.JenkinsJobsList");
    }

    /**
     * Key {@code Dashboard.Total}: {@code total}.
     * 
     * @return
     *     {@code total}
     */
    public static String Dashboard_Total() {
        return holder.format("Dashboard.Total");
    }

    /**
     * Key {@code Dashboard.Total}: {@code total}.
     * 
     * @return
     *     {@code total}
     */
    public static Localizable _Dashboard_Total() {
        return new Localizable(holder, "Dashboard.Total");
    }

    /**
     * Key {@code Dashboard.NoRecentBuildsFailed}: {@code No recent builds
     * failed}.
     * 
     * @return
     *     {@code No recent builds failed}
     */
    public static String Dashboard_NoRecentBuildsFailed() {
        return holder.format("Dashboard.NoRecentBuildsFailed");
    }

    /**
     * Key {@code Dashboard.NoRecentBuildsFailed}: {@code No recent builds
     * failed}.
     * 
     * @return
     *     {@code No recent builds failed}
     */
    public static Localizable _Dashboard_NoRecentBuildsFailed() {
        return new Localizable(holder, "Dashboard.NoRecentBuildsFailed");
    }

    /**
     * Key {@code Dashboard.UnknownStatus}: {@code Unknown status}.
     * 
     * @return
     *     {@code Unknown status}
     */
    public static String Dashboard_UnknownStatus() {
        return holder.format("Dashboard.UnknownStatus");
    }

    /**
     * Key {@code Dashboard.UnknownStatus}: {@code Unknown status}.
     * 
     * @return
     *     {@code Unknown status}
     */
    public static Localizable _Dashboard_UnknownStatus() {
        return new Localizable(holder, "Dashboard.UnknownStatus");
    }

    /**
     * Key {@code Dashboard.UrlHttp}: {@code URL must be http or https.}.
     * 
     * @return
     *     {@code URL must be http or https.}
     */
    public static String Dashboard_UrlHttp() {
        return holder.format("Dashboard.UrlHttp");
    }

    /**
     * Key {@code Dashboard.UrlHttp}: {@code URL must be http or https.}.
     * 
     * @return
     *     {@code URL must be http or https.}
     */
    public static Localizable _Dashboard_UrlHttp() {
        return new Localizable(holder, "Dashboard.UrlHttp");
    }

    /**
     * Key {@code Dashboard.UnstableJobs}: {@code Unstable Jobs}.
     * 
     * @return
     *     {@code Unstable Jobs}
     */
    public static String Dashboard_UnstableJobs() {
        return holder.format("Dashboard.UnstableJobs");
    }

    /**
     * Key {@code Dashboard.UnstableJobs}: {@code Unstable Jobs}.
     * 
     * @return
     *     {@code Unstable Jobs}
     */
    public static Localizable _Dashboard_UnstableJobs() {
        return new Localizable(holder, "Dashboard.UnstableJobs");
    }

    /**
     * Key {@code Dashboard.TestStatisticsGrid}: {@code Test Statistics
     * Grid}.
     * 
     * @return
     *     {@code Test Statistics Grid}
     */
    public static String Dashboard_TestStatisticsGrid() {
        return holder.format("Dashboard.TestStatisticsGrid");
    }

    /**
     * Key {@code Dashboard.TestStatisticsGrid}: {@code Test Statistics
     * Grid}.
     * 
     * @return
     *     {@code Test Statistics Grid}
     */
    public static Localizable _Dashboard_TestStatisticsGrid() {
        return new Localizable(holder, "Dashboard.TestStatisticsGrid");
    }

    /**
     * Key {@code Dashboard.JobsGrid}: {@code Jobs Grid}.
     * 
     * @return
     *     {@code Jobs Grid}
     */
    public static String Dashboard_JobsGrid() {
        return holder.format("Dashboard.JobsGrid");
    }

    /**
     * Key {@code Dashboard.JobsGrid}: {@code Jobs Grid}.
     * 
     * @return
     *     {@code Jobs Grid}
     */
    public static Localizable _Dashboard_JobsGrid() {
        return new Localizable(holder, "Dashboard.JobsGrid");
    }

    /**
     * Key {@code Dashboard.JobStatistics}: {@code Job statistics}.
     * 
     * @return
     *     {@code Job statistics}
     */
    public static String Dashboard_JobStatistics() {
        return holder.format("Dashboard.JobStatistics");
    }

    /**
     * Key {@code Dashboard.JobStatistics}: {@code Job statistics}.
     * 
     * @return
     *     {@code Job statistics}
     */
    public static Localizable _Dashboard_JobStatistics() {
        return new Localizable(holder, "Dashboard.JobStatistics");
    }

    /**
     * Key {@code Dashboard.BuildStatistics}: {@code Build statistics}.
     * 
     * @return
     *     {@code Build statistics}
     */
    public static String Dashboard_BuildStatistics() {
        return holder.format("Dashboard.BuildStatistics");
    }

    /**
     * Key {@code Dashboard.BuildStatistics}: {@code Build statistics}.
     * 
     * @return
     *     {@code Build statistics}
     */
    public static Localizable _Dashboard_BuildStatistics() {
        return new Localizable(holder, "Dashboard.BuildStatistics");
    }

    /**
     * Key {@code Dashboard.RecentBuildsFailed}: {@code {0}-{1}% of recent
     * builds failed}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0}-{1}% of recent builds failed}
     */
    public static String Dashboard_RecentBuildsFailed(Object arg0, Object arg1) {
        return holder.format("Dashboard.RecentBuildsFailed", arg0, arg1);
    }

    /**
     * Key {@code Dashboard.RecentBuildsFailed}: {@code {0}-{1}% of recent
     * builds failed}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0}-{1}% of recent builds failed}
     */
    public static Localizable _Dashboard_RecentBuildsFailed(Object arg0, Object arg1) {
        return new Localizable(holder, "Dashboard.RecentBuildsFailed", arg0, arg1);
    }

    /**
     * Key {@code Dashboard.AgentStatistics}: {@code Agent statistics}.
     * 
     * @return
     *     {@code Agent statistics}
     */
    public static String Dashboard_AgentStatistics() {
        return holder.format("Dashboard.AgentStatistics");
    }

    /**
     * Key {@code Dashboard.AgentStatistics}: {@code Agent statistics}.
     * 
     * @return
     *     {@code Agent statistics}
     */
    public static Localizable _Dashboard_AgentStatistics() {
        return new Localizable(holder, "Dashboard.AgentStatistics");
    }

    /**
     * Key {@code Dashboard.UrlInvalid}: {@code URL is invalid: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code URL is invalid: {0}}
     */
    public static String Dashboard_UrlInvalid(Object arg0) {
        return holder.format("Dashboard.UrlInvalid", arg0);
    }

    /**
     * Key {@code Dashboard.UrlInvalid}: {@code URL is invalid: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code URL is invalid: {0}}
     */
    public static Localizable _Dashboard_UrlInvalid(Object arg0) {
        return new Localizable(holder, "Dashboard.UrlInvalid", arg0);
    }

    /**
     * Key {@code Dashboard.LatestBuilds}: {@code Latest builds}.
     * 
     * @return
     *     {@code Latest builds}
     */
    public static String Dashboard_LatestBuilds() {
        return holder.format("Dashboard.LatestBuilds");
    }

    /**
     * Key {@code Dashboard.LatestBuilds}: {@code Latest builds}.
     * 
     * @return
     *     {@code Latest builds}
     */
    public static Localizable _Dashboard_LatestBuilds() {
        return new Localizable(holder, "Dashboard.LatestBuilds");
    }

    /**
     * Key {@code Dashboard.Count}: {@code count}.
     * 
     * @return
     *     {@code count}
     */
    public static String Dashboard_Count() {
        return holder.format("Dashboard.Count");
    }

    /**
     * Key {@code Dashboard.Count}: {@code count}.
     * 
     * @return
     *     {@code count}
     */
    public static Localizable _Dashboard_Count() {
        return new Localizable(holder, "Dashboard.Count");
    }

    /**
     * Key {@code Dashboard.Date}: {@code date}.
     * 
     * @return
     *     {@code date}
     */
    public static String Dashboard_Date() {
        return holder.format("Dashboard.Date");
    }

    /**
     * Key {@code Dashboard.Date}: {@code date}.
     * 
     * @return
     *     {@code date}
     */
    public static Localizable _Dashboard_Date() {
        return new Localizable(holder, "Dashboard.Date");
    }

    /**
     * Key {@code Dashboard.ImageUrlInvalid}: {@code Image URL is invalid:
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Image URL is invalid: {0}}
     */
    public static String Dashboard_ImageUrlInvalid(Object arg0) {
        return holder.format("Dashboard.ImageUrlInvalid", arg0);
    }

    /**
     * Key {@code Dashboard.ImageUrlInvalid}: {@code Image URL is invalid:
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Image URL is invalid: {0}}
     */
    public static Localizable _Dashboard_ImageUrlInvalid(Object arg0) {
        return new Localizable(holder, "Dashboard.ImageUrlInvalid", arg0);
    }

}
