/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.view.dashboard.builds;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.view.dashboard.DashboardPortlet;
import hudson.plugins.view.dashboard.Messages;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.PriorityQueue;
import org.kohsuke.stapler.DataBoundConstructor;

public class LatestBuilds
extends DashboardPortlet {
    private int numBuilds = 10;

    @DataBoundConstructor
    public LatestBuilds(String name, int numBuilds) {
        super(name);
        this.numBuilds = numBuilds;
    }

    public int getNumBuilds() {
        return this.numBuilds <= 0 ? 10 : this.numBuilds;
    }

    public String getTimestampSortData(Run run) {
        return String.valueOf(run.getTimeInMillis());
    }

    public String getTimestampString(Run run) {
        return DateFormat.getDateTimeInstance(2, 2).format(new Date(run.getTimeInMillis()));
    }

    public List<Run> getFinishedBuilds() {
        Run build;
        List<Job> jobs = this.getDashboardJobs();
        PriorityQueue<Run> queue = new PriorityQueue<Run>(this.numBuilds, Run.ORDER_BY_DATE);
        for (Job job : jobs) {
            Run lb = job.getLastBuild();
            if (lb == null) continue;
            queue.add(lb);
        }
        ArrayList<Run> recentBuilds = new ArrayList<Run>(this.numBuilds);
        while ((build = (Run)queue.poll()) != null) {
            recentBuilds.add(build);
            if (recentBuilds.size() == this.numBuilds) break;
            Run pb = build.getPreviousBuild();
            if (pb == null) continue;
            queue.add(pb);
        }
        return recentBuilds;
    }

    protected List<Job> getDashboardJobs() {
        return this.getDashboard().getJobs();
    }

    public String getBuildColumnSortData(Run<?, ?> build) {
        return String.valueOf(build.getNumber());
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<DashboardPortlet> {
        public String getDisplayName() {
            return Messages.Dashboard_LatestBuilds();
        }
    }
}

