/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.view.dashboard.stats;

import hudson.Extension;
import hudson.model.BallColor;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import hudson.plugins.view.dashboard.DashboardPortlet;
import hudson.plugins.view.dashboard.Messages;
import hudson.util.RunList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.kohsuke.stapler.DataBoundConstructor;

public class StatBuilds
extends DashboardPortlet {
    static final int MAX_BUILDS = Integer.getInteger(StatBuilds.class.getName() + ".maxBuilds", 10);

    @DataBoundConstructor
    public StatBuilds(String name) {
        super(name);
    }

    public Map<BallColor, Integer> getBuildStat(List<TopLevelItem> jobs) {
        TreeMap<BallColor, Integer> colStatBuilds = new TreeMap<BallColor, Integer>();
        for (BallColor color : BallColor.values()) {
            colStatBuilds.put(color.noAnime(), 0);
        }
        for (TopLevelItem job : jobs) {
            if (!(job instanceof Job)) continue;
            RunList builds = ((Job)job).getBuilds().limit(MAX_BUILDS);
            for (Run build : builds) {
                BallColor bColor = build.getIconColor();
                if (bColor == null || bColor.noAnime() == null || colStatBuilds.get(bColor) == null) continue;
                colStatBuilds.put(bColor.noAnime(), (Integer)colStatBuilds.get(bColor) + 1);
            }
        }
        return colStatBuilds;
    }

    public float roundFloatDecimal(float input) {
        float rounded = Math.round(input * 100.0f);
        return rounded /= 100.0f;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<DashboardPortlet> {
        public String getDisplayName() {
            return Messages.Dashboard_BuildStatistics();
        }
    }
}

