/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.credentialsbinding.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.slaves.WorkspaceList;
import java.io.IOException;
import java.util.UUID;
import org.jenkinsci.plugins.credentialsbinding.MultiBinding;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class UnbindableDir {
    private final FilePath dirPath;
    private final MultiBinding.Unbinder unbinder;

    private UnbindableDir(FilePath dirPath) {
        this.dirPath = dirPath;
        this.unbinder = new UnbinderImpl(dirPath.getName());
    }

    public MultiBinding.Unbinder getUnbinder() {
        return this.unbinder;
    }

    public FilePath getDirPath() {
        return this.dirPath;
    }

    public static UnbindableDir create(@NonNull FilePath workspace) throws IOException, InterruptedException {
        FilePath secrets = UnbindableDir.secretsDir(workspace);
        String dirName = UUID.randomUUID().toString();
        FilePath dir = secrets.child(dirName);
        dir.mkdirs();
        secrets.chmod(448);
        dir.chmod(448);
        return new UnbindableDir(dir);
    }

    private static FilePath secretsDir(FilePath workspace) throws IOException {
        FilePath path = WorkspaceList.tempDir((FilePath)workspace);
        if (path == null) {
            throw new IOException("Failed to create tempDir");
        }
        return path.child("secretFiles");
    }

    @Restricted(value={NoExternalUse.class})
    protected static class UnbinderImpl
    implements MultiBinding.Unbinder {
        private static final long serialVersionUID = 1L;
        private final String dirName;

        protected UnbinderImpl(String dirName) {
            this.dirName = dirName;
        }

        @Override
        public void unbind(@NonNull Run<?, ?> build, FilePath workspace, Launcher launcher, @NonNull TaskListener listener) throws IOException, InterruptedException {
            UnbindableDir.secretsDir(workspace).child(this.dirName).deleteRecursive();
        }
    }
}

