/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.credentialsbinding.masking;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.jenkinsci.plugins.credentialsbinding.masking.SecretPatternFactory;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public class BashSecretPatternFactory
implements SecretPatternFactory {
    private static final Pattern QUOTED_CHARS = Pattern.compile("(\\\\)(\\\\?)");

    @NonNull
    private String getQuotedForm(@NonNull String input) {
        StringBuilder sb = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\'') {
                sb.append("'\\''");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @NonNull
    private String surroundWithQuotes(@NonNull String input) {
        return "'" + input + "'";
    }

    @NonNull
    private String getUnquotedForm(@NonNull String input) {
        return QUOTED_CHARS.matcher(input).replaceAll("$2");
    }

    @Override
    @NonNull
    public Collection<String> getEncodedForms(@NonNull String input) {
        HashSet<String> patterns = new HashSet<String>();
        String quotedForm = this.getQuotedForm(input);
        patterns.add(quotedForm);
        patterns.add(this.surroundWithQuotes(quotedForm));
        patterns.add(this.getUnquotedForm(input));
        return patterns;
    }
}

