/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.credentialsbinding.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Functions;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

final class MaskedException
extends Exception {
    private static final long serialVersionUID = 1L;

    static Throwable of(@NonNull Throwable unmasked, Pattern pattern) {
        return MaskedException.of(unmasked, new HashSet<Throwable>(), pattern);
    }

    private static Throwable of(@NonNull Throwable unmasked, @NonNull Set<Throwable> visited, Pattern pattern) {
        if (!visited.add(unmasked)) {
            return new Exception("cycle");
        }
        String text = Functions.printThrowable((Throwable)unmasked);
        if (pattern.matcher(text).find()) {
            MaskedException masked = new MaskedException(pattern.matcher(Objects.requireNonNullElse(unmasked.getMessage(), "")).replaceAll("****"));
            masked.setStackTrace(unmasked.getStackTrace());
            Throwable cause = unmasked.getCause();
            if (cause != null) {
                masked.initCause(MaskedException.of(cause, visited, pattern));
            }
            for (Throwable suppressed : unmasked.getSuppressed()) {
                masked.addSuppressed(MaskedException.of(suppressed, visited, pattern));
            }
            return masked;
        }
        return unmasked;
    }

    private MaskedException(String message) {
        super(message);
    }
}

