/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.copyartifact;

import hudson.EnvVars;
import hudson.model.Job;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.plugins.copyartifact.BuildFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ParametersBuildFilter
extends BuildFilter {
    private static final Logger LOGGER = Logger.getLogger(ParametersBuildFilter.class.getName());
    private List<StringParameterValue> filters = new ArrayList<StringParameterValue>(5);
    private static final Pattern PARAMVAL_PATTERN = Pattern.compile("(.*?)=([^,]*)(,|$)");
    private static final Pattern REGEX_PATTERN = Pattern.compile("[.*+?^$()\\[\\]{}|\\\\]");

    private boolean matchesParameterValue(String expectedValue, String actualValue) {
        if (actualValue == null) {
            return false;
        }
        if (REGEX_PATTERN.matcher(expectedValue).find()) {
            try {
                Pattern pattern = Pattern.compile(expectedValue);
                boolean matches = pattern.matcher(actualValue).matches();
                LOGGER.log(Level.FINE, "ParametersBuildFilter.matchesParameterValue: Regex match - pattern: ''{0}'', value: ''{1}'', matches: {2}", new Object[]{expectedValue, actualValue, matches});
                return matches;
            }
            catch (PatternSyntaxException e) {
                LOGGER.log(Level.FINE, "ParametersBuildFilter.matchesParameterValue: Invalid regex pattern ''{0}'', falling back to exact match", expectedValue);
                return Objects.equals(expectedValue, actualValue);
            }
        }
        return Objects.equals(expectedValue, actualValue);
    }

    public ParametersBuildFilter(String paramsToMatch) {
        Matcher m = PARAMVAL_PATTERN.matcher(paramsToMatch);
        while (m.find()) {
            this.filters.add(new StringParameterValue(m.group(1), m.group(2)));
        }
    }

    public boolean isValid(Job<?, ?> job) {
        if (this.filters.isEmpty()) {
            LOGGER.log(Level.FINE, "ParametersBuildFilter.isValid: No filters parsed for job {0}", job.getFullName());
            return false;
        }
        LOGGER.log(Level.FINE, "ParametersBuildFilter.isValid: Checking if job {0} has any build with required parameters: {1}", new Object[]{job.getFullName(), this.filters});
        int checkedBuilds = 0;
        for (Run run = job.getLastCompletedBuild(); run != null; run = run.getPreviousCompletedBuild()) {
            ++checkedBuilds;
            try {
                StringParameterValue spv2;
                block5: {
                    EnvVars env = run.getEnvironment(TaskListener.NULL);
                    for (StringParameterValue spv2 : this.filters) {
                        if (env.containsKey((Object)spv2.getName())) continue;
                        break block5;
                    }
                    LOGGER.log(Level.FINE, "ParametersBuildFilter.isValid: Found valid build #{0} for job {1} with all required parameters", new Object[]{run.getNumber(), job.getFullName()});
                    return true;
                }
                LOGGER.log(Level.FINE, "ParametersBuildFilter.isValid: Build #{0} missing parameter {1}, continuing search", new Object[]{run.getNumber(), spv2.getName()});
                continue;
            }
            catch (IOException | InterruptedException ex) {
                LOGGER.log(Level.FINE, "ParametersBuildFilter.isValid: Failed to get environment for build #{0}: {1}", new Object[]{run.getNumber(), ex.getMessage()});
                if (checkedBuilds < 10) continue;
                LOGGER.log(Level.FINE, "ParametersBuildFilter.isValid: Checked {0} builds for job {1}, stopping search to avoid spam", new Object[]{checkedBuilds, job.getFullName()});
                break;
            }
        }
        LOGGER.log(Level.FINE, "ParametersBuildFilter.isValid: No valid builds found for job {0} after checking {1} builds", new Object[]{job.getFullName(), checkedBuilds});
        return false;
    }

    @Override
    public boolean isSelectable(Run<?, ?> run, EnvVars env) {
        EnvVars otherEnv;
        LOGGER.log(Level.FINE, "ParametersBuildFilter.isSelectable: Checking build #{0} with filters: {1}", new Object[]{run.getNumber(), this.filters});
        try {
            otherEnv = run.getEnvironment(TaskListener.NULL);
            LOGGER.log(Level.FINE, "ParametersBuildFilter.isSelectable: Successfully got environment for build #{0}", run.getNumber());
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "ParametersBuildFilter.isSelectable: getEnvironment() failed for build #{0}, trying ParametersAction fallback: {1}", new Object[]{run.getNumber(), ex.getMessage()});
            otherEnv = new EnvVars();
            try {
                for (ParametersAction pa : run.getActions(ParametersAction.class)) {
                    for (ParameterValue pv : pa.getParameters()) {
                        pv.buildEnvironment(run, otherEnv);
                    }
                }
                LOGGER.log(Level.FINE, "ParametersBuildFilter.isSelectable: Successfully extracted {0} parameters from ParametersAction for build #{1}", new Object[]{otherEnv.size(), run.getNumber()});
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINE, "ParametersBuildFilter.isSelectable: Failed to get parameters for build #{0}: {1}", new Object[]{run.getNumber(), ex2.getMessage()});
                return false;
            }
        }
        for (StringParameterValue spv : this.filters) {
            String matchType;
            String actualValue;
            String expectedValue = spv.getValue();
            if (!this.matchesParameterValue(expectedValue, actualValue = (String)otherEnv.get((Object)spv.getName()))) {
                matchType = REGEX_PATTERN.matcher(expectedValue).find() ? "regex" : "exact";
                LOGGER.log(Level.FINE, "ParametersBuildFilter.isSelectable: Build #{0} parameter mismatch ({4}) - {1}: expected ''{2}'', got ''{3}''", new Object[]{run.getNumber(), spv.getName(), expectedValue, actualValue, matchType});
                return false;
            }
            matchType = REGEX_PATTERN.matcher(expectedValue).find() ? "regex" : "exact";
            LOGGER.log(Level.FINE, "ParametersBuildFilter.isSelectable: Build #{0} parameter match ({4}) - {1}=''{2}''", new Object[]{run.getNumber(), spv.getName(), actualValue, null, matchType});
        }
        LOGGER.log(Level.FINE, "ParametersBuildFilter.isSelectable: Build #{0} selected - all parameters match", run.getNumber());
        return true;
    }
}

