/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.copyartifact;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.EnvVars;
import hudson.ExtensionPoint;
import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.copyartifact.BuildFilter;
import hudson.plugins.copyartifact.Messages;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.util.VirtualFile;

public abstract class BuildSelector
extends AbstractDescribableImpl<BuildSelector>
implements ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(BuildSelector.class.getName());

    public Run<?, ?> getBuild(Job<?, ?> job, EnvVars env, BuildFilter filter, Run<?, ?> parent) {
        LOGGER.log(Level.FINE, "BuildSelector.getBuild: Starting build selection for job {0} using selector {1}", new Object[]{job.getFullName(), ((Object)((Object)this)).getClass().getSimpleName()});
        if (Util.isOverridden(BuildSelector.class, ((Object)((Object)this)).getClass(), (String)"getBuild", (Class[])new Class[]{Job.class, EnvVars.class, BuildFilter.class})) {
            LOGGER.log(Level.FINE, "BuildSelector.getBuild: Using backward compatibility path");
            Run<?, ?> run = this.getBuild(job, env, filter);
            if (run != null && filter.isSelectable(run, env)) {
                LOGGER.log(Level.FINE, "BuildSelector.getBuild: Selected build #{0} via backward compatibility", run.getNumber());
                return run;
            }
            LOGGER.log(Level.FINE, "BuildSelector.getBuild: No build selected via backward compatibility");
            return null;
        }
        int checkedBuilds = 0;
        for (Run run = job.getLastCompletedBuild(); run != null; run = run.getPreviousCompletedBuild()) {
            ++checkedBuilds;
            LOGGER.log(Level.FINE, "BuildSelector.getBuild: Checking build #{0} (selector: {1}, filter: {2})", new Object[]{run.getNumber(), this.isSelectable(run, env), filter.isSelectable(run, env)});
            if (this.isSelectable(run, env) && filter.isSelectable(run, env)) {
                LOGGER.log(Level.FINE, "BuildSelector.getBuild: Selected build #{0} after checking {1} builds", new Object[]{run.getNumber(), checkedBuilds});
                return run;
            }
            if (checkedBuilds < 20) continue;
            LOGGER.log(Level.FINE, "BuildSelector.getBuild: Checked {0} builds for job {1}, stopping search to avoid spam", new Object[]{checkedBuilds, job.getFullName()});
            break;
        }
        LOGGER.log(Level.FINE, "BuildSelector.getBuild: No suitable build found for job {0} after checking {1} builds", new Object[]{job.getFullName(), checkedBuilds});
        return null;
    }

    @Deprecated
    public Run<?, ?> getBuild(Job<?, ?> job, EnvVars env, BuildFilter filter) {
        return this.getBuild(job, env, filter, null);
    }

    protected boolean isSelectable(Run<?, ?> run, EnvVars env) {
        return false;
    }

    protected static boolean isBuildResultBetterOrEqualTo(Run<?, ?> run, Result resultToTest) {
        if (run == null) {
            return false;
        }
        Result buildResult = run.getResult();
        if (buildResult == null) {
            return false;
        }
        return buildResult.isBetterOrEqualTo(resultToTest);
    }

    @CheckForNull
    protected VirtualFile getArtifacts(Run<?, ?> sourceBuild, PrintStream console) throws IOException, InterruptedException {
        if (Util.isOverridden(BuildSelector.class, ((Object)((Object)this)).getClass(), (String)"getSourceDirectory", (Class[])new Class[]{Run.class, PrintStream.class})) {
            FilePath old = this.getSourceDirectory(sourceBuild, console);
            return old != null ? old.toVirtualFile() : null;
        }
        VirtualFile root = sourceBuild.getArtifactManager().root();
        return root.isDirectory() ? root : null;
    }

    @Deprecated
    protected FilePath getSourceDirectory(Run<?, ?> src, PrintStream console) throws IOException, InterruptedException {
        FilePath srcDir = new FilePath(src.getArtifactsDir());
        if (srcDir.exists()) {
            return srcDir;
        }
        console.println(Messages.CopyArtifact_MissingSrcArtifacts(srcDir));
        return null;
    }
}

