/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.copyartifact;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.copyartifact.BuildFilter;
import hudson.plugins.copyartifact.BuildSelector;
import hudson.plugins.copyartifact.Messages;
import hudson.util.FormValidation;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class DownstreamBuildSelector
extends BuildSelector {
    private static final Logger LOGGER = Logger.getLogger(DownstreamBuildSelector.class.getName());
    private static final String COPIER_PROJECT_KEY = "___COPIER_PROJECT_KEY___";
    private final String upstreamProjectName;
    private final String upstreamBuildNumber;

    @DataBoundConstructor
    public DownstreamBuildSelector(String upstreamProjectName, String upstreamBuildNumber) {
        this.upstreamProjectName = StringUtils.trim((String)upstreamProjectName);
        this.upstreamBuildNumber = StringUtils.trim((String)upstreamBuildNumber);
    }

    public String getUpstreamProjectName() {
        return this.upstreamProjectName;
    }

    public String getUpstreamBuildNumber() {
        return this.upstreamBuildNumber;
    }

    @Override
    public Run<?, ?> getBuild(Job<?, ?> job, EnvVars env, BuildFilter filter, Run<?, ?> parent) {
        EnvVars extendedEnv = new EnvVars(env);
        extendedEnv.put(COPIER_PROJECT_KEY, parent.getParent().getFullName());
        return super.getBuild(job, extendedEnv, filter, parent);
    }

    @Override
    protected boolean isSelectable(Run<?, ?> run, EnvVars env) {
        if (!(run instanceof AbstractBuild)) {
            LOGGER.log(Level.WARNING, "Only applicable to AbstractBuild: but {0} is {1}.", new Object[]{run.getFullDisplayName(), run.getClass().getName()});
            return false;
        }
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null) {
            LOGGER.log(Level.SEVERE, "Jenkins instance isn't available and cannot perform copyartifact from", run.getDisplayName());
            return false;
        }
        Job copier = (Job)jenkins.getItemByFullName((String)env.get((Object)COPIER_PROJECT_KEY), Job.class);
        if (copier instanceof AbstractProject) {
            copier = ((AbstractProject)copier).getRootProject();
        }
        String projectName = env.expand(this.getUpstreamProjectName());
        String buildNumber = env.expand(this.getUpstreamBuildNumber());
        if (StringUtils.isBlank((String)projectName)) {
            LOGGER.warning("Upstream project name gets empty.");
            return false;
        }
        if (StringUtils.isBlank((String)buildNumber)) {
            LOGGER.warning("Upstream build number gets empty.");
            return false;
        }
        Job upstreamJob = (Job)jenkins.getItem(projectName, (Item)copier, Job.class);
        if (upstreamJob == null || !upstreamJob.hasPermission(Item.READ)) {
            LOGGER.warning(String.format("Upstream project '%s' is not found.", projectName));
            return false;
        }
        if (!(upstreamJob instanceof AbstractProject)) {
            LOGGER.log(Level.WARNING, "Only applicable to AbstractProject: but {0} is a {1}.", new Object[]{upstreamJob.getFullName(), upstreamJob.getClass().getName()});
            return false;
        }
        AbstractBuild upstreamBuild = ((AbstractBuild)run).getUpstreamRelationshipBuild((AbstractProject)upstreamJob);
        if (upstreamBuild == null || !upstreamBuild.hasPermission(Item.READ)) {
            LOGGER.fine(String.format("No upstream build of project '%s' is found for build %s-%s.", upstreamJob.getFullName(), run.getParent().getFullName(), run.getDisplayName()));
            return false;
        }
        try {
            int number = Integer.parseInt(buildNumber);
            if (number == upstreamBuild.getNumber()) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (buildNumber.equals(upstreamBuild.getId()) || buildNumber.equals(upstreamBuild.getDisplayName())) {
            return true;
        }
        LOGGER.fine(String.format("build %s-%s doesn't match %s.", run.getParent().getFullName(), run.getDisplayName(), buildNumber));
        return false;
    }

    @Extension
    @Symbol(value={"downstream"})
    public static final class DescriptorImpl
    extends Descriptor<BuildSelector> {
        public String getDisplayName() {
            return Messages.DownstreamBuildSelector_DisplayName();
        }

        protected boolean containsVariable(String str) {
            return !StringUtils.isBlank((String)str) && str.indexOf(36) >= 0;
        }

        public FormValidation doCheckUpstreamProjectName(@AncestorInPath Job<?, ?> project, @QueryParameter String upstreamProjectName) {
            if (StringUtils.isBlank((String)(upstreamProjectName = StringUtils.trim((String)upstreamProjectName)))) {
                return FormValidation.error((String)Messages.DownstreamBuildSelector_UpstreamProjectName_Required());
            }
            if (this.containsVariable(upstreamProjectName)) {
                return FormValidation.ok();
            }
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins == null) {
                return FormValidation.ok();
            }
            if (project == null) {
                return FormValidation.ok((String)Messages.CopyArtifact_AncestorIsNull());
            }
            AbstractProject upstreamRoot = project instanceof AbstractProject ? ((AbstractProject)project).getRootProject() : project;
            Job upstreamProject = (Job)jenkins.getItem(upstreamProjectName, (Item)upstreamRoot, Job.class);
            if (upstreamProject == null || !upstreamProject.hasPermission(Item.READ)) {
                return FormValidation.error((String)Messages.DownstreamBuildSelector_UpstreamProjectName_NotFound());
            }
            if (!(upstreamProject instanceof AbstractProject)) {
                return FormValidation.error((String)Messages.DownstreamBuildSelector_UpstreamProjectName_NotAbstractProject(upstreamProject.getClass().getName()));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckUpstreamBuildNumber(@AncestorInPath Job<?, ?> project, @QueryParameter String upstreamProjectName, @QueryParameter String upstreamBuildNumber) {
            upstreamProjectName = StringUtils.trim((String)upstreamProjectName);
            upstreamBuildNumber = StringUtils.trim((String)upstreamBuildNumber);
            if (StringUtils.isBlank((String)upstreamProjectName) || this.containsVariable(upstreamProjectName)) {
                return FormValidation.ok();
            }
            if (StringUtils.isBlank((String)upstreamBuildNumber)) {
                return FormValidation.error((String)Messages.DownstreamBuildSelector_UpstreamBuildNumber_Required());
            }
            if (this.containsVariable(upstreamBuildNumber)) {
                return FormValidation.ok();
            }
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins == null) {
                return FormValidation.ok();
            }
            if (project == null) {
                return FormValidation.ok((String)Messages.CopyArtifact_AncestorIsNull());
            }
            AbstractProject upstreamRoot = project instanceof AbstractProject ? ((AbstractProject)project).getRootProject() : project;
            AbstractProject upstreamProject = (AbstractProject)jenkins.getItem(upstreamProjectName, (Item)upstreamRoot, AbstractProject.class);
            if (upstreamProject == null || !upstreamProject.hasPermission(Item.READ)) {
                return FormValidation.ok();
            }
            try {
                int number = Integer.parseInt(upstreamBuildNumber);
                AbstractBuild upstreamBuild = upstreamProject.getBuildByNumber(number);
                if (upstreamBuild != null && upstreamBuild.hasPermission(Item.READ)) {
                    return FormValidation.ok();
                }
            }
            catch (NumberFormatException number) {
                // empty catch block
            }
            AbstractBuild upstreamBuild = upstreamProject.getBuild(upstreamBuildNumber);
            if (upstreamBuild != null && upstreamBuild.hasPermission(Item.READ)) {
                return FormValidation.ok();
            }
            for (upstreamBuild = (AbstractBuild)upstreamProject.getLastCompletedBuild(); upstreamBuild != null; upstreamBuild = (AbstractBuild)upstreamBuild.getPreviousCompletedBuild()) {
                if (!upstreamBuild.getDisplayName().equals(upstreamBuildNumber)) continue;
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.DownstreamBuildSelector_UpstreamBuildNumber_NotFound());
        }

        public AutoCompletionCandidates doAutoCompleteUpstreamProjectName(@QueryParameter String value, @AncestorInPath Job<?, ?> project) {
            return project == null ? new AutoCompletionCandidates() : AutoCompletionCandidates.ofJobNames(Item.class, (String)value, project, (ItemGroup)project.getParent());
        }
    }
}

