/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.copyartifact;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.copyartifact.Messages;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

public class CopyArtifactPermissionProperty
extends JobProperty<Job<?, ?>> {
    public static final String PROPERTY_NAME = "copy-artifact-permission-property";
    private final List<String> projectNameList;

    public List<String> getProjectNameList() {
        return this.projectNameList;
    }

    public String getProjectNames() {
        return StringUtils.join(this.projectNameList, (char)',');
    }

    @DataBoundConstructor
    public CopyArtifactPermissionProperty(String projectNames) {
        List<String> rawProjectNameList = Arrays.asList(projectNames != null ? StringUtils.split((String)projectNames, (char)',') : new String[]{});
        this.projectNameList = new ArrayList<String>(rawProjectNameList.size());
        for (String rawProjectName : rawProjectNameList) {
            if (StringUtils.isBlank((String)rawProjectName)) continue;
            this.projectNameList.add(StringUtils.trim((String)rawProjectName));
        }
    }

    public boolean canCopiedBy(Job<?, ?> copier) {
        String copierName = copier.getRelativeNameFrom(this.owner.getParent());
        String absoluteName = String.format("/%s", copier.getFullName());
        for (String projectName : this.getProjectNameList()) {
            if (!CopyArtifactPermissionProperty.isNameMatch(copierName, projectName) && !CopyArtifactPermissionProperty.isNameMatch(absoluteName, projectName)) continue;
            return true;
        }
        return false;
    }

    static boolean isNameMatch(String name, String pattern) {
        if (pattern == null || name == null) {
            return false;
        }
        if (!pattern.contains("*")) {
            return pattern.equals(name);
        }
        List<String> literals = Arrays.asList(pattern.split("\\*", -1));
        String regex = literals.stream().map(input -> input != null ? Pattern.quote(input) : "").collect(Collectors.joining(".*"));
        return name.matches(regex);
    }

    public static boolean canCopyArtifact(Job<?, ?> copier, Job<?, ?> copiee) {
        CopyArtifactPermissionProperty prop = (CopyArtifactPermissionProperty)copiee.getProperty(CopyArtifactPermissionProperty.class);
        if (prop == null) {
            return false;
        }
        return prop.canCopiedBy(copier);
    }

    @Extension
    @Symbol(value={"copyArtifactPermission"})
    public static class DescriptorImpl
    extends JobPropertyDescriptor {
        public String getDisplayName() {
            return Messages.CopyArtifactPermissionProperty_DisplayName();
        }

        public String getPropertyName() {
            return CopyArtifactPermissionProperty.PROPERTY_NAME;
        }

        public CopyArtifactPermissionProperty newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            if (formData == null || formData.isNullObject()) {
                return null;
            }
            JSONObject form = formData.getJSONObject(this.getPropertyName());
            if (form == null || form.isNullObject()) {
                return null;
            }
            return (CopyArtifactPermissionProperty)super.newInstance(req, form);
        }

        List<String> checkNotFoundProjects(String projectNames, @CheckForNull ItemGroup<?> context) {
            if (StringUtils.isBlank((String)projectNames)) {
                return Collections.emptyList();
            }
            ArrayList<String> notFound = new ArrayList<String>();
            for (String projectName : StringUtils.split((String)projectNames, (char)',')) {
                Job proj;
                if (StringUtils.isBlank((String)projectName) || (projectName = StringUtils.trim((String)projectName)).contains("*")) continue;
                Jenkins jenkins = Jenkins.getInstanceOrNull();
                Job job = jenkins == null ? null : (proj = (Job)jenkins.getItem(projectName, (ItemGroup)(context != null ? context : jenkins), Job.class));
                if (proj != null && (!(proj instanceof AbstractProject) || ((AbstractProject)proj).getRootProject() == proj) && proj.hasPermission(Item.READ)) continue;
                notFound.add(projectName);
            }
            return notFound;
        }

        public FormValidation doCheckProjectNames(@QueryParameter String projectNames, @AncestorInPath @CheckForNull Job<?, ?> job) {
            List<String> notFound = this.checkNotFoundProjects(projectNames, job != null ? job.getParent() : null);
            if (!notFound.isEmpty()) {
                return FormValidation.warning((String)Messages.CopyArtifactPermissionProperty_MissingProject(StringUtils.join(notFound, (String)",")));
            }
            return FormValidation.ok();
        }

        public AutoCompletionCandidates doAutoCompleteProjectNames(@QueryParameter String value, @AncestorInPath @CheckForNull Job<?, ?> currentJob) {
            AutoCompletionCandidates candidates = new AutoCompletionCandidates();
            if (StringUtils.isBlank((String)value)) {
                return candidates;
            }
            value = StringUtils.trim((String)value);
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins == null) {
                return candidates;
            }
            for (Job project : jenkins.getAllItems(Job.class)) {
                String absoluteName;
                String relativeName;
                if (project instanceof AbstractProject && ((AbstractProject)project).getRootProject() != project || !project.hasPermission(Item.READ)) continue;
                if (currentJob != null && (relativeName = project.getRelativeNameFrom(currentJob.getParent())).startsWith(value)) {
                    candidates.add(relativeName);
                }
                if (!value.startsWith("/") || !(absoluteName = String.format("/%s", project.getFullName())).startsWith(value)) continue;
                candidates.add(absoluteName);
            }
            return candidates;
        }
    }
}

