/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.copyartifact;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.plugins.copyartifact.CopyArtifactCompatibilityMode;
import java.io.IOException;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Symbol(value={"copyartifact"})
public class CopyArtifactConfiguration
extends GlobalConfiguration {
    private static final Logger LOGGER = Logger.getLogger(CopyArtifactConfiguration.class.getName());
    @NonNull
    private CopyArtifactCompatibilityMode mode = CopyArtifactCompatibilityMode.PRODUCTION;

    public CopyArtifactConfiguration() {
        this.load();
    }

    public synchronized void load() {
        boolean firstLoadOfConfiguration = this.isFirstLoad();
        super.load();
        if (firstLoadOfConfiguration) {
            boolean alreadyInstalledBefore = false;
            try {
                alreadyInstalledBefore = Jenkins.get().getRootPath().child("plugins").child("copyartifact.bak").exists();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!alreadyInstalledBefore) {
                LOGGER.info("CopyArtifact is set to Production mode.");
                this.setModeWithoutSave(CopyArtifactCompatibilityMode.PRODUCTION);
            } else {
                LOGGER.info("CopyArtifact is set to Migration mode as the older version of copyartifact is detected.");
                this.setModeWithoutSave(CopyArtifactCompatibilityMode.MIGRATION);
            }
        }
    }

    @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED, before=InitMilestone.JOB_LOADED)
    public static void syncToDiskForFirstLoad() {
        CopyArtifactConfiguration config = CopyArtifactConfiguration.get();
        if (config == null) {
            LOGGER.severe("Could not get CopyArtifactConfiguration. It looks failed to initialized for some reason");
            return;
        }
        if (config.isFirstLoad()) {
            config.save();
        }
    }

    protected boolean isFirstLoad() {
        return !this.getConfigFile().exists();
    }

    @Restricted(value={NoExternalUse.class})
    public void setToFirstLoad() throws IOException {
        this.getConfigFile().delete();
    }

    @NonNull
    public CopyArtifactCompatibilityMode getMode() {
        return this.mode;
    }

    @Restricted(value={NoExternalUse.class})
    protected void setModeWithoutSave(@NonNull CopyArtifactCompatibilityMode mode) {
        this.mode = mode;
    }

    public void setMode(@NonNull CopyArtifactCompatibilityMode mode) {
        this.setModeWithoutSave(mode);
        this.save();
    }

    public static boolean isMigrationMode() {
        CopyArtifactConfiguration config = CopyArtifactConfiguration.get();
        if (config == null) {
            return false;
        }
        return CopyArtifactCompatibilityMode.MIGRATION.equals((Object)config.getMode());
    }

    @NonNull
    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(GlobalConfigurationCategory.Security.class);
    }

    @CheckForNull
    public static CopyArtifactConfiguration get() {
        return (CopyArtifactConfiguration)((Object)GlobalConfiguration.all().get(CopyArtifactConfiguration.class));
    }
}

