package io.jenkins.plugins.copyprojectlink;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.TopLevelItem;
import hudson.model.TransientProjectActionFactory;
import java.util.Collection;
import java.util.Collections;

@Extension
public class CopyProjectActionFactory extends TransientProjectActionFactory {
    @Override
    public Collection<? extends Action> createFor(AbstractProject target) {
        return target instanceof TopLevelItem
                ? Collections.singleton(new CopyAction<AbstractProject<?, ?>>(target))
                : Collections.<Action>emptyList();
    }
}
