// CHECKSTYLE:OFF

package io.jenkins.plugins.column;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code ConsoleColumn.Last.Successful.DisplayName}: {@code Last
     * Successful Console}.
     * 
     * @return
     *     {@code Last Successful Console}
     */
    public static String ConsoleColumn_Last_Successful_DisplayName() {
        return holder.format("ConsoleColumn.Last.Successful.DisplayName");
    }

    /**
     * Key {@code ConsoleColumn.Last.Successful.DisplayName}: {@code Last
     * Successful Console}.
     * 
     * @return
     *     {@code Last Successful Console}
     */
    public static Localizable _ConsoleColumn_Last_Successful_DisplayName() {
        return new Localizable(holder, "ConsoleColumn.Last.Successful.DisplayName");
    }

    /**
     * Key {@code ConsoleColumn.Last.DisplayName}: {@code Last Console}.
     * 
     * @return
     *     {@code Last Console}
     */
    public static String ConsoleColumn_Last_DisplayName() {
        return holder.format("ConsoleColumn.Last.DisplayName");
    }

    /**
     * Key {@code ConsoleColumn.Last.DisplayName}: {@code Last Console}.
     * 
     * @return
     *     {@code Last Console}
     */
    public static Localizable _ConsoleColumn_Last_DisplayName() {
        return new Localizable(holder, "ConsoleColumn.Last.DisplayName");
    }

    /**
     * Key {@code ConsoleColumn.Last.Unsuccessful.DisplayName}: {@code Last
     * Unsuccessful Console}.
     * 
     * @return
     *     {@code Last Unsuccessful Console}
     */
    public static String ConsoleColumn_Last_Unsuccessful_DisplayName() {
        return holder.format("ConsoleColumn.Last.Unsuccessful.DisplayName");
    }

    /**
     * Key {@code ConsoleColumn.Last.Unsuccessful.DisplayName}: {@code Last
     * Unsuccessful Console}.
     * 
     * @return
     *     {@code Last Unsuccessful Console}
     */
    public static Localizable _ConsoleColumn_Last_Unsuccessful_DisplayName() {
        return new Localizable(holder, "ConsoleColumn.Last.Unsuccessful.DisplayName");
    }

    /**
     * Key {@code ConsoleColumn.Last.Stable.DisplayName}: {@code Last Stable
     * Console}.
     * 
     * @return
     *     {@code Last Stable Console}
     */
    public static String ConsoleColumn_Last_Stable_DisplayName() {
        return holder.format("ConsoleColumn.Last.Stable.DisplayName");
    }

    /**
     * Key {@code ConsoleColumn.Last.Stable.DisplayName}: {@code Last Stable
     * Console}.
     * 
     * @return
     *     {@code Last Stable Console}
     */
    public static Localizable _ConsoleColumn_Last_Stable_DisplayName() {
        return new Localizable(holder, "ConsoleColumn.Last.Stable.DisplayName");
    }

    /**
     * Key {@code XStreamCompatibility.beforeInitMilestonePluginsStarted}:
     * {@code Registering XStream Compatibility Aliases}.
     * 
     * @return
     *     {@code Registering XStream Compatibility Aliases}
     */
    public static String XStreamCompatibility_beforeInitMilestonePluginsStarted() {
        return holder.format("XStreamCompatibility.beforeInitMilestonePluginsStarted");
    }

    /**
     * Key {@code XStreamCompatibility.beforeInitMilestonePluginsStarted}:
     * {@code Registering XStream Compatibility Aliases}.
     * 
     * @return
     *     {@code Registering XStream Compatibility Aliases}
     */
    public static Localizable _XStreamCompatibility_beforeInitMilestonePluginsStarted() {
        return new Localizable(holder, "XStreamCompatibility.beforeInitMilestonePluginsStarted");
    }

    /**
     * Key {@code ConsoleColumn.Last.Failed.DisplayName}: {@code Last Failed
     * Console}.
     * 
     * @return
     *     {@code Last Failed Console}
     */
    public static String ConsoleColumn_Last_Failed_DisplayName() {
        return holder.format("ConsoleColumn.Last.Failed.DisplayName");
    }

    /**
     * Key {@code ConsoleColumn.Last.Failed.DisplayName}: {@code Last Failed
     * Console}.
     * 
     * @return
     *     {@code Last Failed Console}
     */
    public static Localizable _ConsoleColumn_Last_Failed_DisplayName() {
        return new Localizable(holder, "ConsoleColumn.Last.Failed.DisplayName");
    }

    /**
     * Key {@code ConsoleColumn.Last.Unstable.DisplayName}: {@code Last
     * Unstable Console}.
     * 
     * @return
     *     {@code Last Unstable Console}
     */
    public static String ConsoleColumn_Last_Unstable_DisplayName() {
        return holder.format("ConsoleColumn.Last.Unstable.DisplayName");
    }

    /**
     * Key {@code ConsoleColumn.Last.Unstable.DisplayName}: {@code Last
     * Unstable Console}.
     * 
     * @return
     *     {@code Last Unstable Console}
     */
    public static Localizable _ConsoleColumn_Last_Unstable_DisplayName() {
        return new Localizable(holder, "ConsoleColumn.Last.Unstable.DisplayName");
    }

}
