/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing.timestamper;

import configurationslicing.TopLevelItemSelector;
import configurationslicing.UnorderedStringSlicer;
import hudson.Extension;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.plugins.timestamper.TimestamperBuildWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@Extension(optional=true)
public class TimestamperSlicer
extends UnorderedStringSlicer<BuildableItemWithBuildWrappers> {
    public TimestamperSlicer() {
        super(new TimestamperSliceSpec());
    }

    @Override
    public void loadPluginDependencyClass() {
        TimestamperBuildWrapper.class.getClass();
    }

    public static class TimestamperSliceSpec
    extends UnorderedStringSlicer.UnorderedStringSlicerSpec<BuildableItemWithBuildWrappers> {
        private static final String DISABLED = Boolean.FALSE.toString();

        @Override
        public List<String> getCommonValueStrings() {
            ArrayList<String> booleans = new ArrayList<String>();
            booleans.add(Boolean.TRUE.toString());
            return booleans;
        }

        @Override
        public String getDefaultValueString() {
            return DISABLED;
        }

        @Override
        public String getName() {
            return "Timestamper Slicer";
        }

        @Override
        public String getName(BuildableItemWithBuildWrappers item) {
            return item.getFullName();
        }

        @Override
        public String getUrl() {
            return "timestamper";
        }

        @Override
        public boolean isBlankNeededForValues() {
            return false;
        }

        @Override
        public List<String> getValues(BuildableItemWithBuildWrappers item) {
            BuildableItemWithBuildWrappers project = item;
            TimestamperBuildWrapper wrapper = (TimestamperBuildWrapper)project.getBuildWrappersList().get(TimestamperBuildWrapper.class);
            String value = wrapper != null ? Boolean.TRUE.toString() : DISABLED;
            ArrayList<String> booleans = new ArrayList<String>();
            booleans.add(value);
            return booleans;
        }

        @Override
        public List<BuildableItemWithBuildWrappers> getWorkDomain() {
            return TopLevelItemSelector.getAllTopLevelItems(BuildableItemWithBuildWrappers.class);
        }

        @Override
        public boolean setValues(BuildableItemWithBuildWrappers item, List<String> set) {
            boolean changed;
            boolean isTimestampPresent;
            BuildableItemWithBuildWrappers project = item;
            String value = set.iterator().next();
            boolean isTimestampWanted = Boolean.parseBoolean(value);
            TimestamperBuildWrapper wrapper = (TimestamperBuildWrapper)project.getBuildWrappersList().get(TimestamperBuildWrapper.class);
            boolean bl = isTimestampPresent = wrapper != null;
            if (isTimestampPresent && !isTimestampWanted) {
                changed = true;
                try {
                    project.getBuildWrappersList().remove(TimestamperBuildWrapper.class);
                }
                catch (IOException e) {
                    return false;
                }
            } else if (!isTimestampPresent && isTimestampWanted) {
                changed = true;
                project.getBuildWrappersList().add((Object)new TimestamperBuildWrapper());
            } else {
                changed = false;
            }
            return changed;
        }
    }
}

