/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing.maven;

import configurationslicing.UnorderedStringSlicer;
import hudson.Extension;
import hudson.maven.MavenModuleSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;

@Extension(optional=true)
public class MavenGoals
extends UnorderedStringSlicer<MavenModuleSet> {
    public MavenGoals() {
        super(new MavenGoalsSlicerSpec());
    }

    @Override
    public void loadPluginDependencyClass() {
        MavenModuleSet.class.getClass();
    }

    public static class MavenGoalsSlicerSpec
    extends UnorderedStringSlicer.UnorderedStringSlicerSpec<MavenModuleSet> {
        private static final String DEFAULT = "(Default)";

        @Override
        public String getDefaultValueString() {
            return DEFAULT;
        }

        @Override
        public String getName() {
            return "Maven Goals and Options (Maven project)";
        }

        @Override
        public String getName(MavenModuleSet item) {
            return item.getFullName();
        }

        @Override
        public String getUrl() {
            return "mavengoals";
        }

        @Override
        public List<String> getValues(MavenModuleSet item) {
            ArrayList<String> ret = new ArrayList<String>();
            String goals = item.getUserConfiguredGoals();
            ret.add(goals == null ? DEFAULT : goals);
            return ret;
        }

        @Override
        public List<MavenModuleSet> getWorkDomain() {
            return Jenkins.get().getAllItems(MavenModuleSet.class);
        }

        @Override
        public boolean setValues(MavenModuleSet item, List<String> set) {
            if (set.isEmpty()) {
                return false;
            }
            String value = set.iterator().next();
            if (DEFAULT.equalsIgnoreCase(value)) {
                item.setGoals(null);
            } else {
                item.setGoals(value);
            }
            try {
                item.save();
            }
            catch (IOException e) {
                return false;
            }
            return true;
        }
    }
}

