/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing.email;

import configurationslicing.UnorderedStringSlicer;
import configurationslicing.email.AbstractEmailSliceSpec;
import configurationslicing.email.ProjectHandler;
import hudson.Extension;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenReporter;
import hudson.maven.reporters.MavenMailer;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.tasks.Mailer;
import hudson.tasks.Publisher;
import hudson.util.DescribableList;
import java.io.IOException;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;

@Extension(optional=true)
public class CoreEmailSlicer
extends UnorderedStringSlicer<AbstractProject> {
    public CoreEmailSlicer() {
        super(new CoreEmailSliceSpec());
    }

    public static class CoreEmailSliceSpec
    extends AbstractEmailSliceSpec {
        public CoreEmailSliceSpec() {
            super(" ", "E-mail Notification", "mailer");
        }

        @Override
        protected ProjectHandler getProjectHandler(AbstractProject project) {
            if (project instanceof MavenModuleSet) {
                return MavenEmailProjectHandler.INSTANCE;
            }
            return CoreEmailProjectHandler.INSTANCE;
        }
    }

    private static class MavenEmailProjectHandler
    implements ProjectHandler {
        public static final MavenEmailProjectHandler INSTANCE = new MavenEmailProjectHandler();

        private MavenEmailProjectHandler() {
        }

        @Override
        public String getRecipients(AbstractProject project) {
            MavenMailer mailer = this.getMailer(project);
            if (mailer != null) {
                return mailer.recipients;
            }
            return null;
        }

        private MavenMailer getMailer(AbstractProject project) {
            MavenModuleSet mavenProject = (MavenModuleSet)project;
            DescribableList reporters = mavenProject.getReporters();
            Descriptor descriptor = Jenkins.get().getDescriptor(MavenMailer.class);
            MavenReporter emailReporter = (MavenReporter)reporters.get(descriptor);
            return (MavenMailer)emailReporter;
        }

        @Override
        public boolean setRecipients(AbstractProject project, String value) {
            MavenMailer mailer = this.getMailer(project);
            if (!StringUtils.equals((String)value, (String)mailer.recipients)) {
                mailer.recipients = value;
                return true;
            }
            return false;
        }

        @Override
        public boolean addMailer(AbstractProject project) throws IOException {
            MavenMailer mailer = this.getMailer(project);
            if (mailer == null) {
                MavenModuleSet mavenProject = (MavenModuleSet)project;
                DescribableList reporters = mavenProject.getReporters();
                reporters.add((Object)new MavenMailer());
                return true;
            }
            return false;
        }

        @Override
        public boolean removeMailer(AbstractProject project) throws IOException {
            MavenMailer mailer = this.getMailer(project);
            if (mailer != null) {
                MavenModuleSet mavenProject = (MavenModuleSet)project;
                DescribableList reporters = mavenProject.getReporters();
                reporters.remove((Object)mailer);
                return true;
            }
            return false;
        }

        @Override
        public boolean sendToIndividuals(AbstractProject project) {
            MavenMailer mailer = this.getMailer(project);
            if (mailer != null) {
                return mailer.sendToIndividuals;
            }
            return false;
        }
    }

    private static class CoreEmailProjectHandler
    implements ProjectHandler {
        public static final CoreEmailProjectHandler INSTANCE = new CoreEmailProjectHandler();

        private CoreEmailProjectHandler() {
        }

        @Override
        public String getRecipients(AbstractProject project) {
            Mailer mailer = this.getMailer(project);
            if (mailer != null) {
                return mailer.recipients;
            }
            return null;
        }

        private Mailer getMailer(AbstractProject project) {
            DescribableList publishers = project.getPublishersList();
            Descriptor descriptor = Jenkins.get().getDescriptor(Mailer.class);
            Publisher emailPublisher = (Publisher)publishers.get(descriptor);
            return (Mailer)emailPublisher;
        }

        @Override
        public boolean setRecipients(AbstractProject project, String value) {
            Mailer mailer = this.getMailer(project);
            if (!StringUtils.equals((String)value, (String)mailer.recipients)) {
                mailer.recipients = value;
                return true;
            }
            return false;
        }

        @Override
        public boolean addMailer(AbstractProject project) throws IOException {
            Mailer mailer = this.getMailer(project);
            if (mailer == null) {
                DescribableList publishers = project.getPublishersList();
                publishers.add((Object)new Mailer());
                return true;
            }
            return false;
        }

        @Override
        public boolean removeMailer(AbstractProject project) throws IOException {
            Mailer mailer = this.getMailer(project);
            if (mailer != null) {
                DescribableList publishers = project.getPublishersList();
                publishers.remove((Object)mailer);
                return true;
            }
            return false;
        }

        @Override
        public boolean sendToIndividuals(AbstractProject project) {
            Mailer mailer = this.getMailer(project);
            if (mailer != null) {
                return mailer.sendToIndividuals;
            }
            return false;
        }
    }
}

