/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing;

import configurationslicing.BooleanSlicer;
import configurationslicing.Slice;
import hudson.model.Descriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public class BooleanSlice<I>
extends Slice {
    private Map<String, Boolean> nameToValue = new HashMap<String, Boolean>();
    private BooleanSlicer.BooleanSlicerSpec<I> spec;

    public BooleanSlice(BooleanSlicer.BooleanSlicerSpec<I> spec, List<ItemState> list) {
        this(spec);
        for (ItemState istate : list) {
            this.add(istate.itemname, istate.checked);
        }
    }

    public BooleanSlice(BooleanSlicer.BooleanSlicerSpec<I> spec) {
        this.spec = spec;
    }

    public void add(String name, boolean value) {
        this.nameToValue.put(name, value);
    }

    public boolean exists(String name) {
        return this.nameToValue.get(name) != null;
    }

    public boolean get(String name) {
        Boolean object = this.nameToValue.get(name);
        if (object == null) {
            return false;
        }
        return object;
    }

    public BooleanSlicer.BooleanSlicerSpec<I> getSpec() {
        return this.spec;
    }

    public List<I> getConfiguredItems() {
        ArrayList<I> items = new ArrayList<I>();
        List<I> all = this.spec.getWorkDomain();
        for (I i : all) {
            String name = this.spec.getName(i);
            if (!this.nameToValue.containsKey(name)) continue;
            items.add(i);
        }
        return items;
    }

    @Override
    public Slice newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
        return new BooleanSlice<I>(this.spec, req.bindJSONToList(ItemState.class, formData.get("itemstate")));
    }

    public static class ItemState {
        private String itemname;
        private boolean checked;

        @DataBoundConstructor
        public ItemState(String itemname, boolean checked) {
            this.itemname = itemname;
            this.checked = checked;
        }
    }
}

