// CHECKSTYLE:OFF

package configurationslicing;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code configurationSlicing.description}: {@code Configure a

     * single aspect across a group of items, in contrast to the traditional

     * configuration of all aspects of a single item}.
     * 
     * @return
     *     {@code Configure a single aspect across a group of items, in contrast

     *     to the traditional configuration of all aspects of a single item}
     */
    public static String configurationSlicing_description() {
        return holder.format("configurationSlicing.description");
    }

    /**
     * Key {@code configurationSlicing.description}: {@code Configure a

     * single aspect across a group of items, in contrast to the traditional

     * configuration of all aspects of a single item}.
     * 
     * @return
     *     {@code Configure a single aspect across a group of items, in contrast

     *     to the traditional configuration of all aspects of a single item}
     */
    public static Localizable _configurationSlicing_description() {
        return new Localizable(holder, "configurationSlicing.description");
    }

    /**
     * Key {@code configurationSlicing.displayName}: {@code Configuration

     * Slicing}.
     * 
     * @return
     *     {@code Configuration Slicing}
     */
    public static String configurationSlicing_displayName() {
        return holder.format("configurationSlicing.displayName");
    }

    /**
     * Key {@code configurationSlicing.displayName}: {@code Configuration

     * Slicing}.
     * 
     * @return
     *     {@code Configuration Slicing}
     */
    public static Localizable _configurationSlicing_displayName() {
        return new Localizable(holder, "configurationSlicing.displayName");
    }

    /**
     * Key {@code configurationSlicing.configuredValueDescription}: {@code

     * Configured Value}.
     * 
     * @return
     *     {@code Configured Value}
     */
    public static String configurationSlicing_configuredValueDescription() {
        return holder.format("configurationSlicing.configuredValueDescription");
    }

    /**
     * Key {@code configurationSlicing.configuredValueDescription}: {@code

     * Configured Value}.
     * 
     * @return
     *     {@code Configured Value}
     */
    public static Localizable _configurationSlicing_configuredValueDescription() {
        return new Localizable(holder, "configurationSlicing.configuredValueDescription");
    }

}
