/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing.pipeline;

import configurationslicing.TopLevelItemSelector;
import configurationslicing.UnorderedStringSlicer;
import hudson.Extension;
import hudson.model.Descriptor;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;

@Extension(optional=true)
public class PipelineScriptSlicer
extends UnorderedStringSlicer<WorkflowJob> {
    private static final Logger LOGGER = Logger.getLogger(PipelineScriptSlicer.class.getName());

    public PipelineScriptSlicer() {
        super(new PipelineScriptSliceSpec());
    }

    @Override
    public void loadPluginDependencyClass() {
        CpsFlowDefinition.class.getClass();
    }

    public static class PipelineScriptSliceSpec
    extends UnorderedStringSlicer.UnorderedStringSlicerSpec<WorkflowJob> {
        private static final String DEFINED_IN_SCM = "(Defined in SCM)";
        private static final String EMPTY = "(Empty)";

        @Override
        public String getDefaultValueString() {
            return DEFINED_IN_SCM;
        }

        @Override
        public String getName() {
            return "Pipeline Script Slicer";
        }

        @Override
        public String getName(WorkflowJob item) {
            return item.getFullName();
        }

        @Override
        public String getUrl() {
            return "pipelinescriptslicestring";
        }

        @Override
        public List<String> getValues(WorkflowJob item) {
            CpsFlowDefinition flowDefinition;
            String flow;
            FlowDefinition definition = item.getDefinition();
            String string = flow = definition == null ? EMPTY : DEFINED_IN_SCM;
            if (definition instanceof CpsFlowDefinition && StringUtils.isEmpty((String)(flow = (flowDefinition = (CpsFlowDefinition)definition).getScript()))) {
                flow = EMPTY;
            }
            return Collections.singletonList(flow);
        }

        @Override
        public List<WorkflowJob> getWorkDomain() {
            return TopLevelItemSelector.getAllTopLevelItems(WorkflowJob.class);
        }

        private void setDefinition(WorkflowJob item, String definition) {
            try {
                item.setDefinition((FlowDefinition)new CpsFlowDefinition(definition, true));
            }
            catch (Descriptor.FormException e) {
                LOGGER.log(Level.FINE, "Cannot set definition", e);
            }
        }

        @Override
        public boolean setValues(WorkflowJob item, List<String> set) {
            String newValue;
            if (set.isEmpty() || set.size() > 1) {
                return false;
            }
            String oldValue = this.getValues(item).iterator().next();
            if (!oldValue.equals(newValue = set.iterator().next())) {
                switch (newValue) {
                    case "(Defined in SCM)": {
                        break;
                    }
                    case "(Empty)": {
                        this.setDefinition(item, "");
                    }
                    default: {
                        this.setDefinition(item, newValue);
                    }
                }
            }
            return false;
        }
    }
}

